/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.tools.util.InvalidREvaluationResultException;
import kieker.tools.util.OutputStream2StandardLog;
import org.math.R.Rsession;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class RBridgeControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RBridgeControl.class);
    private static final AtomicInteger NEXTVARID = new AtomicInteger(1);
    private Rsession rCon;

    protected RBridgeControl() {
        block2: {
            OutputStream2StandardLog out = new OutputStream2StandardLog();
            try {
                this.rCon = Rsession.newLocalInstance((PrintStream)new PrintStream((OutputStream)out, true, "UTF-8"), null);
            }
            catch (UnsupportedEncodingException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error(e.toString(), (Throwable)e);
            }
        }
    }

    public Object evalWithR(String input) throws InvalidREvaluationResultException {
        REXP out;
        block8: {
            out = null;
            try {
                out = this.rCon.eval(input);
                String output = null;
                if (out instanceof REXPString) {
                    output = ((REXPString)out).asString();
                } else if (out instanceof REXPLogical) {
                    output = ((REXPLogical)out).toDebugString();
                } else if (out != null) {
                    output = out;
                } else {
                    throw new InvalidREvaluationResultException("Got a null result for evaluation input: \"" + input + "\"");
                }
                LOGGER.trace("> REXP: {} return: {}", (Object)input, (Object)output);
            }
            catch (REXPMismatchException exc) {
                if (!LOGGER.isErrorEnabled()) break block8;
                LOGGER.error("Error R expr.: {} Cause: {}", new Object[]{input, exc.getMessage(), exc});
            }
        }
        return out;
    }

    public void toTS(String variable) throws InvalidREvaluationResultException {
        if (variable != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(variable).append(" <- ts(").append(variable).append(')');
            this.evalWithR(buf.toString());
        }
    }

    public void toTS(String variable, long frequency) throws InvalidREvaluationResultException {
        if (variable != null) {
            StringBuffer buf = new StringBuffer(21);
            buf.append(variable).append(" <- ts(").append(variable).append(", frequency=").append(frequency).append(')');
            this.evalWithR(buf.toString());
        }
    }

    public double eDbl(String input) {
        double resultOnFailure = Double.NaN;
        try {
            Object evaluationResult = this.evalWithR(input);
            REXPDouble doubleResult = (REXPDouble)evaluationResult;
            return doubleResult.asDouble();
        }
        catch (REXPMismatchException exc) {
            LOGGER.error("Error casting value from R: {} Cause: {}", (Object)input, (Object)exc);
            return Double.NaN;
        }
        catch (InvalidREvaluationResultException exc) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(exc.getMessage(), (Throwable)exc);
            }
            return Double.NaN;
        }
    }

    public String eString(String input) {
        String resultOnFailure = "";
        try {
            Object evaluationResult = this.evalWithR(input);
            REXPString stringResult = (REXPString)evaluationResult;
            return stringResult.toString();
        }
        catch (InvalidREvaluationResultException exc) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(exc.getMessage(), (Throwable)exc);
            }
            return "";
        }
    }

    public double[] eDblArr(String input) {
        double[] resultOnFailure = new double[]{};
        try {
            Object evaluationResult = this.evalWithR(input);
            REXPVector vectorResult = (REXPVector)evaluationResult;
            return vectorResult.asDoubles();
        }
        catch (REXPMismatchException e) {
            return resultOnFailure;
        }
        catch (InvalidREvaluationResultException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return resultOnFailure;
        }
    }

    public void assign(String variable, double[] values) throws InvalidREvaluationResultException {
        StringBuffer buf = new StringBuffer();
        buf.append(variable).append(" <- c(");
        boolean first = true;
        for (double item : values) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(item);
        }
        buf.append(')');
        this.evalWithR(buf.toString());
    }

    public void assign(String variable, Double[] values) throws InvalidREvaluationResultException {
        StringBuffer buf = new StringBuffer();
        buf.append(variable).append(" <- c(");
        boolean first = true;
        for (Double item : values) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            if (null == item || item.isNaN()) {
                buf.append("NA");
                continue;
            }
            buf.append(item);
        }
        buf.append(')');
        this.evalWithR(buf.toString());
    }

    public void assign(String variable, Long[] values) throws InvalidREvaluationResultException {
        StringBuffer buf = new StringBuffer();
        buf.append(variable).append(" <- c(");
        boolean first = true;
        for (Long item : values) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(item);
        }
        buf.append(',');
        this.evalWithR(buf.toString());
    }

    public static String uniqueVarname() {
        return String.format("var_%s", NEXTVARID.getAndIncrement());
    }

    public static RBridgeControl getInstance() {
        return LazyHolderFactory.INSTANCE;
    }

    private static final class LazyHolderFactory {
        static final RBridgeControl INSTANCE = new RBridgeControl();

        private LazyHolderFactory() {
        }
    }
}

