/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.graph;

import java.util.HashSet;
import java.util.Set;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.OriginRetentionPolicyKind;

public class SpecificOriginRetentionPolicy
extends AbstractOriginRetentionPolicy {
    private final Set<Object> selectedOrigins = new HashSet<Object>();
    private IOriginRetentionPolicy successor;

    protected SpecificOriginRetentionPolicy(Set<?> selectedOrigins) {
        super(OriginRetentionPolicyKind.SPECIFIC);
        this.selectedOrigins.addAll(selectedOrigins);
    }

    @Override
    public boolean dependsOn(IOriginRetentionPolicy policy) {
        if (this == policy) {
            return true;
        }
        if (this.successor == null) {
            return false;
        }
        return this.successor.equals(policy) || this.successor.dependsOn(policy);
    }

    @Override
    public IOriginRetentionPolicy uniteWith(IOriginRetentionPolicy other) {
        if (other == null) {
            return this;
        }
        switch (other.getKind()) {
            case NONE: {
                return this;
            }
            case SPECIFIC: {
                if (other.dependsOn(this)) {
                    throw new IllegalArgumentException(other.toString());
                }
                this.successor = other;
                return this;
            }
            case ALL: {
                return other;
            }
        }
        throw new IllegalArgumentException(other.toString());
    }

    @Override
    public <T> void handleOrigin(AbstractGraphElement<T> element, T origin) {
        if (this.selectedOrigins.contains(origin)) {
            element.addOrigin(origin);
        }
        if (this.successor != null) {
            this.successor.handleOrigin(element, origin);
        }
    }

    public static SpecificOriginRetentionPolicy createInstance(Set<?> selectedOrigins) {
        return new SpecificOriginRetentionPolicy(selectedOrigins);
    }
}

