/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.common;

import com.beust.jcommander.JCommander;
import kieker.common.exception.ConfigurationException;
import kieker.tools.common.AbstractLegacyTool;
import teetime.framework.Configuration;
import teetime.framework.Execution;

public abstract class AbstractService<T extends Configuration, R>
extends AbstractLegacyTool<R> {
    @Override
    protected int execute(JCommander commander, String label) throws ConfigurationException {
        Execution execution = new Execution(this.createTeetimeConfiguration());
        Thread shutdownThread = this.shutdownHook(execution);
        this.logger.debug("Running {}", (Object)label);
        execution.executeBlocking();
        if (!shutdownThread.isAlive()) {
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
        }
        this.shutdownService();
        this.logger.debug("Done");
        return 0;
    }

    private Thread shutdownHook(final Execution<T> execution) {
        Thread shutdownThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Execution execution2 = execution;
                synchronized (execution2) {
                    execution.abortEventually();
                    AbstractService.this.shutdownService();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        return shutdownThread;
    }

    protected abstract T createTeetimeConfiguration() throws ConfigurationException;
}

