package net.kensand.kielbasa.kotest.property

import io.kotest.property.Arb
import io.kotest.property.arbitrary.boolean
import io.kotest.property.arbitrary.byte
import io.kotest.property.arbitrary.byteArray
import io.kotest.property.arbitrary.double
import io.kotest.property.arbitrary.duration
import io.kotest.property.arbitrary.int
import io.kotest.property.arbitrary.long
import io.kotest.property.arbitrary.map
import io.kotest.property.arbitrary.string
import io.kotest.property.kotlinx.datetime.date
import io.kotest.property.kotlinx.datetime.datetime
import io.kotest.property.kotlinx.datetime.instant
import kotlin.io.encoding.Base64
import kotlin.io.encoding.ExperimentalEncodingApi
import kotlin.time.ExperimentalTime

object Generators {
    val string = Arb.string()

    val int = Arb.int()
    val long = Arb.long()
    val double = Arb.double()
    val boolean = Arb.boolean()

    @OptIn(ExperimentalTime::class)
    val instant = Arb.instant().map { kotlin.time.Instant.fromEpochSeconds(it.epochSeconds, it.nanosecondsOfSecond) }
    val duration = Arb.duration()
    val localDate = Arb.date()
    val localDateTime = Arb.datetime()

    val byte = Arb.byte()
    val byteArray = Arb.byteArray(Arb.int(0..64), Arb.byte())

    @OptIn(ExperimentalEncodingApi::class)
    val base64 = Arb.byteArray(Arb.int(4..128), Arb.byte()).map { Base64.encode(it) }

    @OptIn(ExperimentalEncodingApi::class)
    val urlEncodedBase64 = Arb.byteArray(Arb.int(4..128), Arb.byte()).map { Base64.UrlSafe.encode(it) }
}
