package net.kensand.kielbasa.kotest.property

import io.kotest.property.Arb
import io.kotest.property.arbitrary.arbitrary
import io.kotest.property.arbitrary.list
import io.kotest.property.arbitrary.map
import kotlinx.coroutines.CompletableDeferred
import kotlinx.coroutines.Deferred
import kotlinx.coroutines.flow.asFlow

fun <A> Arb<A>.nullable() =
    arbitrary {
        if (it.random.nextBoolean()) {
            this@nullable.bind()
        } else {
            null
        }
    }

fun <A> Arb<A>.list(range: IntRange = 0..10) = Arb.list(this, range)

fun <A, B> Pair<Arb<A>, Arb<B>>.map(range: IntRange = 0..10) = Arb.map(first, second, range.first, range.last)

fun <A> Arb<A>.sequence() = arbitrary { rs -> this@sequence.generate(rs).map { it.value } }

fun <A> Arb<A>.flow() = this.sequence().map { it.asFlow() }

fun <A> Arb<A>.deferred(): Arb<Deferred<A>> = map { CompletableDeferred(it) }
