package net.kensand.kielbasa.core

/**
 * Repeat the receiver a given number of times.
 * @receiver The value to be repeated.
 * @param count The number of times the receiver should be repeated.
 * @return A list or repeated receiver values of the desired length.
 */
fun <T> T.repeat(count: Int) = (0 until count).map { this }
