package net.kensand.kielbasa.core

import kotlin.js.ExperimentalJsExport
import kotlin.js.JsExport

/**
 * Repeat the receiver a given number of times.
 * @receiver The value to be repeated.
 * @param count The number of times the receiver should be repeated.
 * @return A list or repeated receiver values of the desired length.
 */
fun <T> T.repeat(count: Int) = (0 until count).map { this }

/**
 * Get whether a value is null.
 * @receiver A nullable value.
 * @return True if the receiver is null, false otherwise.
 */
val <T> T?.isNull
    get() = this == null

/**
 * Get whether a value is not null.
 * @receiver A nullable value.
 * @return False if the receiver is null, true otherwise.
 */
val <T> T?.isNotNull
    get() = this != null

/**
 * A value or null.
 *
 * @param predicate that will determine if the receiver should be returned or null.
 * @receiver The value to check.
 * @return The receiver if the predicate returns true, else null.
 */
@ExperimentalJsExport
@JsExport
fun <T> T.orNull(predicate: (T) -> Boolean): T? =
    if (predicate(this)) {
        this
    } else {
        null
    }
