/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.dsn.InvalidDsnException;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;

public class SentryAppender
extends AppenderBase<ILoggingEvent> {
    public static final String LOGBACK_MARKER = "logback-Marker";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected Raven raven;
    protected String dsn;
    protected String ravenFactory;
    private final boolean propagateClose;

    public SentryAppender() {
        this.propagateClose = true;
    }

    public SentryAppender(Raven raven) {
        this(raven, false);
    }

    public SentryAppender(Raven raven, boolean propagateClose) {
        this.raven = raven;
        this.propagateClose = propagateClose;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> arguments = new ArrayList<String>(parameters.length);
        for (Object argument : parameters) {
            arguments.add(argument != null ? argument.toString() : null);
        }
        return arguments;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        if (((Boolean)Raven.RAVEN_THREAD.get()).booleanValue()) {
            return;
        }
        if (this.raven == null) {
            this.initRaven();
        }
        try {
            Event event = this.buildEvent(iLoggingEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.addError("An exception occurred while creating a new event in Raven", e);
        }
    }

    protected void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.addError("An exception occurred during the retrieval of the DSN for Raven", e);
        }
        catch (Exception e) {
            this.addError("An exception occurred during the creation of a Raven instance", e);
        }
    }

    protected Event buildEvent(ILoggingEvent iLoggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(new Date(iLoggingEvent.getTimeStamp())).setMessage(iLoggingEvent.getFormattedMessage()).setLogger(iLoggingEvent.getLoggerName()).setLevel(SentryAppender.formatLevel(iLoggingEvent.getLevel())).addExtra(THREAD_NAME, (Object)iLoggingEvent.getThreadName());
        if (iLoggingEvent.getArgumentArray() != null) {
            eventBuilder.addSentryInterface((SentryInterface)new MessageInterface(iLoggingEvent.getMessage(), SentryAppender.formatMessageParameters(iLoggingEvent.getArgumentArray())));
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            Throwable throwable = ((ThrowableProxy)iLoggingEvent.getThrowableProxy()).getThrowable();
            eventBuilder.addSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.addSentryInterface((SentryInterface)new StackTraceInterface(iLoggingEvent.getCallerData()));
        }
        if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.setCulprit(iLoggingEvent.getCallerData()[0]);
        } else {
            eventBuilder.setCulprit(iLoggingEvent.getLoggerName());
        }
        for (Map.Entry mdcEntry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            eventBuilder.addExtra((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        if (iLoggingEvent.getMarker() != null) {
            eventBuilder.addTag(LOGBACK_MARKER, iLoggingEvent.getMarker().getName());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void stop() {
        super.stop();
        try {
            if (this.propagateClose && this.raven != null) {
                this.raven.getConnection().close();
            }
        }
        catch (IOException e) {
            this.addError("An exception occurred while closing the Raven connection", e);
        }
    }
}

