/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.dsn.InvalidDsnException;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;

public class SentryAppender
extends AppenderBase<ILoggingEvent> {
    public static final String LOGBACK_MARKER = "logback-Marker";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected Map<String, String> tags = Collections.emptyMap();

    public SentryAppender() {
    }

    public SentryAppender(Raven raven) {
        this.raven = raven;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> arguments = new ArrayList<String>(parameters.length);
        for (Object argument : parameters) {
            arguments.add(argument != null ? argument.toString() : null);
        }
        return arguments;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent iLoggingEvent) {
        if (((Boolean)Raven.RAVEN_THREAD.get()).booleanValue()) {
            return;
        }
        try {
            Raven.RAVEN_THREAD.set(true);
            if (this.raven == null) {
                this.initRaven();
            }
            Event event = this.buildEvent(iLoggingEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.addError("An exception occurred while creating a new event in Raven", e);
        }
        finally {
            Raven.RAVEN_THREAD.remove();
        }
    }

    protected void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.addError("An exception occurred during the retrieval of the DSN for Raven", e);
        }
        catch (Exception e) {
            this.addError("An exception occurred during the creation of a Raven instance", e);
        }
    }

    protected Event buildEvent(ILoggingEvent iLoggingEvent) {
        Throwable throwable;
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(new Date(iLoggingEvent.getTimeStamp())).setMessage(iLoggingEvent.getFormattedMessage()).setLogger(iLoggingEvent.getLoggerName()).setLevel(SentryAppender.formatLevel(iLoggingEvent.getLevel())).addExtra(THREAD_NAME, (Object)iLoggingEvent.getThreadName());
        if (iLoggingEvent.getArgumentArray() != null) {
            eventBuilder.addSentryInterface((SentryInterface)new MessageInterface(iLoggingEvent.getMessage(), SentryAppender.formatMessageParameters(iLoggingEvent.getArgumentArray())));
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            throwable = ((ThrowableProxy)iLoggingEvent.getThrowableProxy()).getThrowable();
            eventBuilder.addSentryInterface((SentryInterface)new ExceptionInterface(throwable)).addSentryInterface((SentryInterface)new StackTraceInterface(throwable));
            if (throwable.getCause() != null && throwable.getCause() != throwable) {
                eventBuilder.generateChecksum(this.buildStackTrace(throwable));
            }
        } else if (iLoggingEvent.getCallerData().length > 0) {
            throwable = new Throwable();
            throwable.setStackTrace(iLoggingEvent.getCallerData());
            eventBuilder.addSentryInterface((SentryInterface)new StackTraceInterface(throwable));
        }
        if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.setCulprit(iLoggingEvent.getCallerData()[0]);
        } else {
            eventBuilder.setCulprit(iLoggingEvent.getLoggerName());
        }
        for (Map.Entry entry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            eventBuilder.addExtra((String)entry.getKey(), entry.getValue());
        }
        if (iLoggingEvent.getMarker() != null) {
            eventBuilder.addTag(LOGBACK_MARKER, iLoggingEvent.getMarker().getName());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.addTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    protected String buildStackTrace(Throwable e) {
        StringBuilder sb = new StringBuilder();
        while (e != null) {
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                sb.append(stackTraceElement.getClassName()).append(stackTraceElement.getMethodName()).append(stackTraceElement.getFileName()).append(stackTraceElement.getLineNumber()).append('\n');
            }
            e = e.getCause();
        }
        return sb.toString();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setTags(String tags) {
        this.tags = Splitter.on((String)",").withKeyValueSeparator(":").split((CharSequence)tags);
    }

    public void stop() {
        super.stop();
        try {
            if (this.raven != null) {
                this.raven.getConnection().close();
            }
        }
        catch (IOException e) {
            this.addError("An exception occurred while closing the Raven connection", e);
        }
    }
}

