/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.kencochrane.raven.Dsn;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;

public class SentryAppender
extends AppenderBase<ILoggingEvent> {
    private final boolean propagateClose;
    private Raven raven;
    private String dsn;
    private String ravenFactory;

    public SentryAppender() {
        this.propagateClose = true;
    }

    public SentryAppender(Raven raven) {
        this(raven, false);
    }

    public SentryAppender(Raven raven, boolean propagateClose) {
        this.raven = raven;
        this.propagateClose = propagateClose;
    }

    private static List<String> formatArguments(Object[] argumentArray) {
        ArrayList<String> arguments = new ArrayList<String>(argumentArray.length);
        for (Object argument : argumentArray) {
            arguments.add(argument.toString());
        }
        return arguments;
    }

    private static Event.Level formatLevel(ILoggingEvent iLoggingEvent) {
        if (iLoggingEvent.getLevel().isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (iLoggingEvent.getLevel().isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (iLoggingEvent.getLevel().isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (iLoggingEvent.getLevel().isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    public void start() {
        try {
            if (this.raven == null) {
                if (this.dsn == null) {
                    this.dsn = Dsn.dsnLookup();
                }
                this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
            }
            super.start();
        }
        catch (Exception e) {
            this.addError("An exception occurred during the creation of a raven instance", e);
        }
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        if (((Boolean)Raven.RAVEN_THREAD.get()).booleanValue()) {
            return;
        }
        Event event = this.buildEvent(iLoggingEvent);
        this.raven.sendEvent(event);
    }

    private Event buildEvent(ILoggingEvent iLoggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(new Date(iLoggingEvent.getTimeStamp())).setMessage(iLoggingEvent.getFormattedMessage()).setLogger(iLoggingEvent.getLoggerName()).setLevel(SentryAppender.formatLevel(iLoggingEvent));
        if (iLoggingEvent.getThrowableProxy() != null) {
            Throwable throwable = ((ThrowableProxy)iLoggingEvent.getThrowableProxy()).getThrowable();
            eventBuilder.addSentryInterface((SentryInterface)new ExceptionInterface(throwable)).addSentryInterface((SentryInterface)new StackTraceInterface(throwable));
        } else {
            if (iLoggingEvent.getArgumentArray() != null) {
                eventBuilder.addSentryInterface((SentryInterface)new MessageInterface(iLoggingEvent.getMessage(), SentryAppender.formatArguments(iLoggingEvent.getArgumentArray())));
            }
            if (iLoggingEvent.getCallerData().length > 0) {
                eventBuilder.generateChecksum(this.getEventPosition(iLoggingEvent));
            }
        }
        if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.setCulprit(iLoggingEvent.getCallerData()[0]);
        } else {
            eventBuilder.setCulprit(iLoggingEvent.getLoggerName());
        }
        for (Map.Entry mdcEntry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            eventBuilder.addExtra((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    private String getEventPosition(ILoggingEvent iLoggingEvent) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTraceElement : iLoggingEvent.getCallerData()) {
            sb.append(stackTraceElement.getClassName()).append(stackTraceElement.getMethodName()).append(stackTraceElement.getLineNumber());
        }
        return sb.toString();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void stop() {
        super.stop();
        try {
            if (this.propagateClose) {
                this.raven.getConnection().close();
            }
        }
        catch (IOException e) {
            this.addError("An exception occurred while closing the raven connection", e);
        }
    }
}

