/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.log4j;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.dsn.InvalidDsnException;
import net.kencochrane.raven.environment.RavenEnvironment;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class SentryAppender
extends AppenderSkeleton {
    public static final String LOG4J_NDC = "log4J-NDC";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();
    protected List<String> mappedTags = Collections.emptyList();

    public SentryAppender() {
    }

    public SentryAppender(Raven raven) {
        this.raven = raven;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual((Priority)Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static StackTraceElement asStackTraceElement(LocationInfo location) {
        String fileName = "?".equals(location.getFileName()) ? null : location.getFileName();
        int line = "?".equals(location.getLineNumber()) ? -1 : Integer.parseInt(location.getLineNumber());
        return new StackTraceElement(location.getClassName(), location.getMethodName(), fileName, line);
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.raven == null) {
            this.initRaven();
        }
    }

    protected void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.getErrorHandler().error("An exception occurred during the retrieval of the DSN for Raven", (Exception)((Object)e), 6);
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred during the creation of a Raven instance", e, 4);
        }
    }

    protected void append(LoggingEvent loggingEvent) {
        if (RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            Event event = this.buildEvent(loggingEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred while creating a new event in Raven", e, 1);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected Event buildEvent(LoggingEvent loggingEvent) {
        LocationInfo location;
        EventBuilder eventBuilder = new EventBuilder().withTimestamp(new Date(loggingEvent.getTimeStamp())).withMessage(loggingEvent.getRenderedMessage()).withLogger(loggingEvent.getLoggerName()).withLevel(SentryAppender.formatLevel(loggingEvent.getLevel())).withExtra(THREAD_NAME, (Object)loggingEvent.getThreadName());
        if (loggingEvent.getThrowableInformation() != null) {
            Throwable throwable = loggingEvent.getThrowableInformation().getThrowable();
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (loggingEvent.getLocationInformation().fullInfo != null && !"?".equals((location = loggingEvent.getLocationInformation()).getFileName()) && !"?".equals(location.getLineNumber())) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{SentryAppender.asStackTraceElement(location)};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (loggingEvent.getLocationInformation().fullInfo != null) {
            eventBuilder.withCulprit(SentryAppender.asStackTraceElement(loggingEvent.getLocationInformation()));
        } else {
            eventBuilder.withCulprit(loggingEvent.getLoggerName());
        }
        if (loggingEvent.getNDC() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)loggingEvent.getNDC());
        }
        Map properties = loggingEvent.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            if (this.extraTags.contains(entry.getKey())) {
                eventBuilder.withTag((String)entry.getKey(), entry.getValue().toString());
                continue;
            }
            eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setTags(String tags) {
        this.tags = Splitter.on((String)",").withKeyValueSeparator(":").split((CharSequence)tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = new HashSet<String>(Arrays.asList(extraTags.split(",")));
    }

    public void close() {
        RavenEnvironment.startManagingThread();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred while closing the Raven connection", e, 3);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

