/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.log4j;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.dsn.InvalidDsnException;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class SentryAppender
extends AppenderSkeleton {
    public static final String LOG4J_NDC = "log4J-NDC";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected Raven raven;
    protected String dsn;
    protected String ravenFactory;
    private final boolean propagateClose;
    private boolean guard;

    public SentryAppender() {
        this.propagateClose = true;
    }

    public SentryAppender(Raven raven) {
        this(raven, false);
    }

    public SentryAppender(Raven raven, boolean propagateClose) {
        this.raven = raven;
        this.propagateClose = propagateClose;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual((Priority)Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static StackTraceElement asStackTraceElement(LocationInfo location) {
        String fileName = "?".equals(location.getFileName()) ? null : location.getFileName();
        int line = "?".equals(location.getLineNumber()) ? -1 : Integer.parseInt(location.getLineNumber());
        return new StackTraceElement(location.getClassName(), location.getMethodName(), fileName, line);
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.raven == null) {
            this.initRaven();
        }
    }

    protected void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.getErrorHandler().error("An exception occurred during the retrieval of the DSN for Raven", (Exception)((Object)e), 6);
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred during the creation of a Raven instance", e, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void append(LoggingEvent loggingEvent) {
        if (((Boolean)Raven.RAVEN_THREAD.get()).booleanValue() || this.guard) {
            return;
        }
        try {
            this.guard = true;
            Event event = this.buildEvent(loggingEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred while creating a new event in Raven", e, 1);
        }
        finally {
            this.guard = false;
        }
    }

    protected Event buildEvent(LoggingEvent loggingEvent) {
        LocationInfo location;
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(new Date(loggingEvent.getTimeStamp())).setMessage(loggingEvent.getRenderedMessage()).setLogger(loggingEvent.getLoggerName()).setLevel(SentryAppender.formatLevel(loggingEvent.getLevel())).addExtra(THREAD_NAME, (Object)loggingEvent.getThreadName());
        if (loggingEvent.getThrowableInformation() != null) {
            Throwable throwable = loggingEvent.getThrowableInformation().getThrowable();
            eventBuilder.addSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (loggingEvent.getLocationInformation().fullInfo != null && !"?".equals((location = loggingEvent.getLocationInformation()).getFileName()) && !"?".equals(location.getLineNumber())) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{SentryAppender.asStackTraceElement(location)};
            eventBuilder.addSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (loggingEvent.getLocationInformation().fullInfo != null) {
            eventBuilder.setCulprit(SentryAppender.asStackTraceElement(loggingEvent.getLocationInformation()));
        } else {
            eventBuilder.setCulprit(loggingEvent.getLoggerName());
        }
        if (loggingEvent.getNDC() != null) {
            eventBuilder.addExtra(LOG4J_NDC, (Object)loggingEvent.getNDC());
        }
        Map properties = loggingEvent.getProperties();
        for (Map.Entry mdcEntry : properties.entrySet()) {
            eventBuilder.addExtra((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.propagateClose && this.raven != null) {
                this.raven.getConnection().close();
            }
        }
        catch (IOException e) {
            this.getErrorHandler().error("An exception occurred while closing the Raven connection", (Exception)e, 3);
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

