/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.log4j;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import net.kencochrane.raven.Dsn;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class SentryAppender
extends AppenderSkeleton {
    private static final String LOG4J_NDC = "Log4J-NDC";
    private final boolean propagateClose;
    private Raven raven;
    private String dsn;
    private String ravenFactory;
    private boolean guard;

    public SentryAppender() {
        this.propagateClose = true;
    }

    public SentryAppender(Raven raven) {
        this(raven, false);
    }

    public SentryAppender(Raven raven, boolean propagateClose) {
        this.raven = raven;
        this.propagateClose = propagateClose;
    }

    private static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual((Priority)Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    private static StackTraceElement asStackTraceElement(LocationInfo location) {
        String fileName = "?".equals(location.getFileName()) ? null : location.getFileName();
        int line = "?".equals(location.getLineNumber()) ? -1 : Integer.parseInt(location.getLineNumber());
        return new StackTraceElement(location.getClassName(), location.getMethodName(), fileName, line);
    }

    public void activateOptions() {
        try {
            if (this.raven == null) {
                if (this.dsn == null) {
                    this.dsn = Dsn.dsnLookup();
                }
                this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
            }
            super.activateOptions();
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred during the creation of a raven instance", e, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void append(LoggingEvent loggingEvent) {
        if (((Boolean)Raven.RAVEN_THREAD.get()).booleanValue() || this.guard) {
            return;
        }
        try {
            this.guard = true;
            Event event = this.buildEvent(loggingEvent);
            this.raven.sendEvent(event);
        }
        finally {
            this.guard = false;
        }
    }

    private Event buildEvent(LoggingEvent loggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(new Date(loggingEvent.getTimeStamp())).setMessage(loggingEvent.getRenderedMessage()).setLogger(loggingEvent.getLoggerName()).setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        if (loggingEvent.getThrowableInformation() != null) {
            Throwable throwable = loggingEvent.getThrowableInformation().getThrowable();
            eventBuilder.addSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (loggingEvent.getLocationInformation().fullInfo != null) {
            eventBuilder.generateChecksum(loggingEvent.getLocationInformation().fullInfo);
        }
        if (loggingEvent.getLocationInformation().fullInfo != null) {
            eventBuilder.setCulprit(SentryAppender.asStackTraceElement(loggingEvent.getLocationInformation()));
        } else {
            eventBuilder.setCulprit(loggingEvent.getLoggerName());
        }
        if (loggingEvent.getNDC() != null) {
            eventBuilder.addExtra(LOG4J_NDC, (Object)loggingEvent.getNDC());
        }
        for (Map.Entry mdcEntry : loggingEvent.getProperties().entrySet()) {
            eventBuilder.addExtra(mdcEntry.getKey().toString(), mdcEntry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void close() {
        try {
            if (this.propagateClose) {
                this.raven.getConnection().close();
            }
        }
        catch (IOException e) {
            this.getErrorHandler().error("An exception occurred while closing the raven connection", (Exception)e, 3);
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

