/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.log4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kencochrane.raven.Client;
import net.kencochrane.raven.SentryDsn;
import net.kencochrane.raven.log4j.Log4jMDC;
import net.kencochrane.raven.spi.JSONProcessor;
import net.kencochrane.raven.spi.RavenMDC;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class SentryAppender
extends AppenderSkeleton {
    private boolean async;
    private Log4jMDC mdc;
    protected String sentryDsn;
    protected Client client;
    protected boolean messageCompressionEnabled = true;
    private List<JSONProcessor> jsonProcessors = Collections.emptyList();

    public SentryAppender() {
        SentryAppender.initMDC();
        this.mdc = (Log4jMDC)RavenMDC.getInstance();
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getSentryDsn() {
        return this.sentryDsn;
    }

    public void setSentryDsn(String sentryDsn) {
        this.sentryDsn = sentryDsn;
    }

    public boolean isMessageCompressionEnabled() {
        return this.messageCompressionEnabled;
    }

    public void setMessageCompressionEnabled(boolean messageCompressionEnabled) {
        this.messageCompressionEnabled = messageCompressionEnabled;
    }

    public void setJsonProcessors(String setting) {
        this.jsonProcessors = SentryAppender.loadJSONProcessors(setting);
    }

    public void notifyProcessorsBeforeAppending() {
        for (JSONProcessor processor : this.jsonProcessors) {
            processor.prepareDiagnosticContext();
        }
    }

    public void notifyProcessorsAfterAppending() {
        for (JSONProcessor processor : this.jsonProcessors) {
            processor.clearDiagnosticContext();
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    @Override
    public void activateOptions() {
        this.client = this.sentryDsn == null ? new Client() : new Client(SentryDsn.buildOptional(this.sentryDsn));
        this.client.setJSONProcessors(this.jsonProcessors);
        this.client.setMessageCompressionEnabled(this.messageCompressionEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void append(LoggingEvent event) {
        this.mdc.setThreadLoggingEvent(event);
        try {
            long timestamp = event.getTimeStamp();
            String message = event.getRenderedMessage();
            String logger = event.getLogger().getName();
            int level = event.getLevel().toInt() / 1000;
            String culprit = event.getLoggerName();
            ThrowableInformation info = event.getThrowableInformation();
            if (!this.async) {
                this.notifyProcessorsBeforeAppending();
            }
            if (info == null) {
                this.client.captureMessage(message, timestamp, logger, level, culprit);
            } else {
                this.client.captureException(message, timestamp, logger, level, culprit, info.getThrowable());
            }
            if (!this.async) {
                this.notifyProcessorsAfterAppending();
            }
        }
        finally {
            this.mdc.removeThreadLoggingEvent();
        }
    }

    private static List<JSONProcessor> loadJSONProcessors(String setting) {
        if (setting == null) {
            return Collections.emptyList();
        }
        try {
            String[] clazzes;
            ArrayList<JSONProcessor> processors = new ArrayList<JSONProcessor>();
            for (String clazz : clazzes = setting.split(",\\s*")) {
                JSONProcessor processor = (JSONProcessor)Class.forName(clazz).newInstance();
                processors.add(processor);
            }
            return processors;
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("Processor could not be found.", exception);
        }
        catch (InstantiationException exception) {
            throw new RuntimeException("Processor could not be instantiated.", exception);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException("Processor could not be instantiated.", exception);
        }
    }

    public static void initMDC() {
        if (RavenMDC.getInstance() != null) {
            if (!(RavenMDC.getInstance() instanceof Log4jMDC)) {
                throw new IllegalStateException("An incompatible RavenMDC instance has been set. Please check your Raven configuration.");
            }
            return;
        }
        RavenMDC.setInstance(new Log4jMDC());
    }
}

