/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.ext;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.kencochrane.raven.ext.RavenServletRequestListener;
import net.kencochrane.raven.spi.JSONProcessor;
import net.kencochrane.raven.spi.RavenMDC;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;

public class ServletJSONProcessor
implements JSONProcessor {
    private static final String HTTP_INTERFACE = "sentry.interfaces.Http";

    @Override
    public void prepareDiagnosticContext() {
        HttpServletRequest request = RavenServletRequestListener.getRequest();
        if (request == null) {
            return;
        }
        RavenMDC.getInstance().put(HTTP_INTERFACE, ServletJSONProcessor.buildHttpObject(request));
    }

    @Override
    public void clearDiagnosticContext() {
        RavenMDC.getInstance().remove(HTTP_INTERFACE);
    }

    @Override
    public void process(JSONObject json, Throwable exception) {
        JSONObject http = (JSONObject)RavenMDC.getInstance().get(HTTP_INTERFACE);
        if (http == null) {
            return;
        }
        json.put(HTTP_INTERFACE, http);
    }

    private static JSONObject buildHttpObject(HttpServletRequest request) {
        JSONObject http = new JSONObject();
        http.put("url", ServletJSONProcessor.getUrl(request));
        http.put("method", request.getMethod());
        http.put("data", ServletJSONProcessor.getData(request));
        http.put("query_string", request.getQueryString());
        http.put("cookies", ServletJSONProcessor.getCookies(request));
        http.put("headers", ServletJSONProcessor.getHeaders(request));
        http.put("env", ServletJSONProcessor.getEnvironmentVariables(request));
        return http;
    }

    private static String getUrl(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }

    private static JSONObject getData(HttpServletRequest request) {
        if (!"POST".equals(request.getMethod())) {
            return null;
        }
        JSONObject data = new JSONObject();
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            data.put(entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return data;
    }

    private static JSONObject getCookies(HttpServletRequest request) {
        JSONObject cookiesMap = new JSONObject();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : request.getCookies()) {
                cookiesMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookiesMap;
    }

    private static JSONObject getHeaders(HttpServletRequest request) {
        JSONObject headers = new JSONObject();
        Enumeration headersEnum = request.getHeaderNames();
        while (headersEnum.hasMoreElements()) {
            String name = (String)headersEnum.nextElement();
            headers.put(ServletJSONProcessor.capitalize(name), request.getHeader(name));
        }
        return headers;
    }

    private static JSONObject getEnvironmentVariables(HttpServletRequest request) {
        JSONObject env = new JSONObject();
        env.put("REMOTE_ADDR", request.getRemoteAddr());
        env.put("SERVER_NAME", request.getServerName());
        env.put("SERVER_PORT", request.getServerPort());
        env.put("SERVER_PROTOCOL", request.getProtocol());
        return env;
    }

    private static String capitalize(String headerName) {
        Object[] tokens = headerName.split("-");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = StringUtils.capitalize((String)tokens[i]);
        }
        return StringUtils.join(tokens, "-");
    }
}

