/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;

public abstract class Utils {
    public static final String SENTRY_DSN = "SENTRY_DSN";
    private static final Map<String, CacheEntry> CACHE = new HashMap<String, CacheEntry>();

    public static String hostname() {
        String cacheKey = "hostname";
        String name = (String)Utils.fromCache("hostname", 360000L);
        if (name == null) {
            try {
                name = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                name = "unavailable";
            }
            CACHE.put("hostname", new CacheEntry<String>(name));
        }
        return name;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static byte[] toUtf8(String s) {
        try {
            return s == null ? new byte[]{} : s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromUtf8(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] compress(byte[] input) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DeflaterOutputStream output = new DeflaterOutputStream(bytes);
        try {
            output.write(input);
            output.close();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decompress(byte[] input) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        InflaterOutputStream output = new InflaterOutputStream(bytes);
        try {
            output.write(input);
            output.close();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> T fromCache(String key, long timeout) {
        CacheEntry entry = CACHE.get(key);
        if (entry == null) {
            return null;
        }
        return entry.timestamp + timeout > Utils.now() ? (T)entry.value : null;
    }

    protected static class CacheEntry<T> {
        public final T value;
        public final long timestamp;

        public CacheEntry(T value) {
            this.value = value;
            this.timestamp = Utils.now();
        }
    }

    public static interface Client {
        public static final String VERSION = "2.0";
        public static final String NAME = "Raven-Java 2.0";
    }
}

