/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.kencochrane.raven.Client;
import net.kencochrane.raven.SentryDsn;
import net.kencochrane.raven.Utils;
import org.apache.commons.lang.StringUtils;

public abstract class Transport {
    public final SentryDsn dsn;
    public final boolean includeSignature;
    protected boolean started;

    public Transport(SentryDsn dsn) {
        this.dsn = dsn;
        this.includeSignature = dsn.getOptionAsBoolean("raven.includeSignature", false);
    }

    public void start() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.started = false;
    }

    public void send(String messageBody, long timestamp) throws IOException {
        if (this.includeSignature) {
            String hmacSignature = Client.sign(messageBody, timestamp, this.dsn.secretKey);
            String authHeader = Transport.buildAuthHeader(hmacSignature, timestamp, this.dsn.publicKey);
            this.doSend(messageBody, authHeader);
        } else {
            this.doSend(messageBody, Transport.buildAuthHeader(timestamp, this.dsn.publicKey));
        }
    }

    protected void doSend(String messageBody, String authHeader) throws IOException {
        throw new UnsupportedOperationException("Nothing to do here...");
    }

    public static String buildAuthHeader(long timestamp, String publicKey) {
        return Transport.buildAuthHeader(null, timestamp, publicKey);
    }

    @Deprecated
    public static String buildAuthHeader(String hmacSignature, long timestamp, String publicKey) {
        StringBuilder header = new StringBuilder();
        header.append("Sentry sentry_version=2.0");
        if (!StringUtils.isBlank(hmacSignature)) {
            header.append(",sentry_signature=").append(hmacSignature);
        }
        header.append(",sentry_timestamp=");
        header.append(timestamp);
        header.append(",sentry_key=");
        header.append(publicKey);
        header.append(",sentry_client=");
        header.append("Raven-Java 2.0");
        return header.toString();
    }

    public static class AcceptAllHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    }

    public static class Udp
    extends Transport {
        private final DatagramSocket socket;

        public Udp(SentryDsn dsn) {
            super(dsn);
            try {
                this.socket = this.createSocket(dsn.host, dsn.port);
            }
            catch (SocketException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        protected void doSend(String messageBody, String authHeader) throws IOException {
            byte[] message = Utils.toUtf8(authHeader + "\n\n" + messageBody);
            DatagramPacket packet = new DatagramPacket(message, message.length);
            this.socket.send(packet);
        }

        protected DatagramSocket createSocket(String host, int port) throws SocketException {
            DatagramSocket socket = new DatagramSocket();
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }
    }

    public static class NaiveHttps
    extends Http {
        private static final HostnameVerifier ACCEPT_ALL = new AcceptAllHostnameVerifier();
        public final HostnameVerifier hostnameVerifier;

        public NaiveHttps(SentryDsn dsn) {
            this(dsn, ACCEPT_ALL);
        }

        public NaiveHttps(SentryDsn dsn, HostnameVerifier hostnameVerifier) {
            super(dsn);
            this.hostnameVerifier = hostnameVerifier;
        }

        @Override
        protected HttpURLConnection getConnection() throws IOException {
            HttpsURLConnection connection = (HttpsURLConnection)this.url.openConnection();
            connection.setHostnameVerifier(this.hostnameVerifier);
            return connection;
        }
    }

    public static class Http
    extends Transport {
        public final URL url;
        public final int timeout;

        public Http(SentryDsn dsn) {
            super(dsn);
            try {
                this.url = new URL(dsn.toString(false) + "/api/store/");
            }
            catch (MalformedURLException e) {
                throw new SentryDsn.InvalidDsnException("URL constructed from Sentry DSN is invalid", e);
            }
            this.timeout = dsn.getOptionAsInt("raven.timeout", 10000);
        }

        @Override
        protected void doSend(String messageBody, String authHeader) throws IOException {
            HttpURLConnection connection = this.getConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.timeout);
            connection.setRequestProperty("X-Sentry-Auth", authHeader);
            OutputStream output = connection.getOutputStream();
            output.write(messageBody.getBytes());
            output.close();
            connection.connect();
            InputStream input = connection.getInputStream();
            input.close();
        }

        protected HttpURLConnection getConnection() throws IOException {
            return (HttpURLConnection)this.url.openConnection();
        }

        public static interface Option {
            public static final String TIMEOUT = "raven.timeout";
            public static final int TIMEOUT_DEFAULT = 10000;
        }
    }

    public static interface Option {
        public static final String INCLUDE_SIGNATURE = "raven.includeSignature";
    }
}

