/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class SentryDsn {
    private static final Logger LOG = Logger.getLogger("raven.client");
    public final String scheme;
    public final String[] variants;
    public final String host;
    public final String publicKey;
    public final String secretKey;
    public final String path;
    public final String projectId;
    public final int port;
    public final Map<String, String> options;

    public SentryDsn(String scheme, String[] variants, String host, String publicKey, String secretKey, String path, String projectId, int port, Map<String, String> options) {
        this.scheme = scheme;
        this.variants = variants == null ? new String[]{} : variants;
        this.host = host;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.path = path;
        this.projectId = projectId;
        this.port = port;
        this.options = options == null ? Collections.emptyMap() : Collections.unmodifiableMap(options);
    }

    public boolean getOptionAsBoolean(String key, boolean defaultValue) {
        String value = this.options.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public int getOptionAsInt(String key, int defaultValue) {
        String value = this.options.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Expected " + key + " to be a valid int");
        }
    }

    public boolean isVariantIncluded(String variant) {
        return Arrays.binarySearch(this.variants, variant) >= 0;
    }

    public String getFullScheme(String ... excludes) {
        Set excludedSchemes = Collections.emptySet();
        if (excludes != null && excludes.length > 0) {
            excludedSchemes = new HashSet<String>(Arrays.asList(excludes));
        }
        String full = "";
        LinkedList<String> parts = new LinkedList<String>();
        for (String variant : this.variants) {
            if (excludedSchemes.contains(variant)) continue;
            parts.add(variant);
        }
        parts.add(this.scheme);
        return StringUtils.join(parts, '+');
    }

    public String toString(boolean full) {
        String fullPath;
        String protocol = !full || this.variants.length == 0 ? this.scheme : StringUtils.join((Object[])this.variants, '+') + "+" + this.scheme;
        String fullHost = this.port < 0 ? this.host : this.host + ":" + this.port;
        String string = fullPath = this.path == null ? "" : this.path;
        if (!full) {
            return String.format("%s://%s%s", protocol, fullHost, fullPath);
        }
        fullPath = fullPath + "/" + this.projectId;
        String user = StringUtils.isBlank(this.secretKey) ? this.publicKey : this.publicKey + ":" + this.secretKey;
        return String.format("%s://%s@%s%s", protocol, user, fullHost, fullPath);
    }

    public String toString() {
        return this.toString(true);
    }

    public static SentryDsn build() {
        return SentryDsn.build(null, DefaultLookUps.values(), null);
    }

    public static SentryDsn buildOptional() {
        try {
            return SentryDsn.build();
        }
        catch (InvalidDsnException e) {
            LOG.log(Level.WARNING, "Could not automatically determine a valid DSN; client will be disabled", e);
            return null;
        }
    }

    public static SentryDsn build(String fullDsn) {
        return SentryDsn.build(fullDsn, DefaultLookUps.values(), null);
    }

    public static SentryDsn buildOptional(String fullDsn) {
        try {
            return SentryDsn.build(fullDsn);
        }
        catch (InvalidDsnException e) {
            LOG.log(Level.WARNING, "Could not automatically determine a valid DSN; client will be disabled", e);
            return null;
        }
    }

    public static SentryDsn build(String fullDsn, LookUp[] overrides, LookUp[] fallbacks) {
        String dsn = StringUtils.defaultString(SentryDsn.firstResult(overrides), StringUtils.defaultString(fullDsn, SentryDsn.firstResult(fallbacks)));
        if (StringUtils.isBlank(dsn)) {
            throw new InvalidDsnException("No valid Sentry DSN found");
        }
        int schemeEnd = dsn.indexOf("://");
        if (schemeEnd <= 0) {
            throw new InvalidDsnException("Expected to discover a scheme in the Sentry DSN");
        }
        String fullScheme = dsn.substring(0, schemeEnd);
        String[] schemeParts = StringUtils.split(fullScheme, '+');
        String scheme = fullScheme;
        String[] variants = null;
        if (schemeParts.length > 1) {
            variants = Arrays.copyOfRange(schemeParts, 0, schemeParts.length - 1);
            scheme = schemeParts[schemeParts.length - 1];
        }
        try {
            URL url = new URL("http" + dsn.substring(schemeEnd));
            String[] userParts = url.getUserInfo().split(":");
            String publicKey = userParts[0];
            String secretKey = null;
            if (userParts.length > 1) {
                secretKey = userParts[1];
            }
            String urlPath = url.getPath();
            int lastSlash = urlPath.lastIndexOf(47);
            String path = urlPath.substring(0, lastSlash);
            String projectId = urlPath.substring(lastSlash + 1);
            Map<String, String> options = SentryDsn.parseQueryString(url.getQuery());
            return new SentryDsn(scheme, variants, url.getHost(), publicKey, secretKey, path, projectId, url.getPort(), options);
        }
        catch (MalformedURLException e) {
            throw new InvalidDsnException("Failed to parse " + dsn, e);
        }
    }

    public static SentryDsn buildOptional(String fullDsn, LookUp[] overrides, LookUp[] fallbacks) {
        try {
            return SentryDsn.build(fullDsn, overrides, fallbacks);
        }
        catch (InvalidDsnException e) {
            LOG.log(Level.WARNING, "Could not automatically determine a valid DSN; client will be disabled", e);
            return null;
        }
    }

    protected static Map<String, String> parseQueryString(String q) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] pairs = StringUtils.split(q, '&');
        if (pairs == null) {
            return map;
        }
        for (String pair : pairs) {
            Object[] components = StringUtils.split(pair, '=');
            String value = components.length == 1 ? null : StringUtils.join(components, '=', 1, components.length);
            map.put((String)components[0], value);
        }
        return map;
    }

    public static String firstResult(LookUp[] lookups) {
        if (lookups == null) {
            return null;
        }
        for (LookUp lookup : lookups) {
            String dsn = lookup.findDsn();
            if (StringUtils.isBlank(dsn)) continue;
            return dsn;
        }
        return null;
    }

    public static enum DefaultLookUps implements LookUp
    {
        ENV{

            @Override
            public String findDsn() {
                return System.getenv("SENTRY_DSN");
            }
        }
        ,
        SYSTEM_PROPERTY{

            @Override
            public String findDsn() {
                return System.getProperty("SENTRY_DSN");
            }
        };

    }

    public static interface LookUp {
        public String findDsn();
    }

    public static class InvalidDsnException
    extends RuntimeException {
        public InvalidDsnException(String message) {
            super(message);
        }

        public InvalidDsnException(String message, Throwable t) {
            super(message, t);
        }
    }
}

