/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.util.Arrays;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class Events {
    public static JSONObject message(String message, Object ... params) {
        return Events.message(new JSONObject(), message, params);
    }

    public static JSONObject message(JSONObject json, String message, Object ... params) {
        JSONObject messageJson = new JSONObject();
        messageJson.put("message", message);
        JSONArray paramArray = new JSONArray();
        if (params != null) {
            paramArray.addAll(Arrays.asList(params));
        }
        messageJson.put("params", paramArray);
        json.put("sentry.interfaces.Message", messageJson);
        return json;
    }

    public static JSONObject query(String query, String engine) {
        return Events.query(new JSONObject(), query, engine);
    }

    public static JSONObject query(JSONObject json, String query, String engine) {
        JSONObject content = new JSONObject();
        content.put("query", query);
        content.put("engine", engine);
        json.put("sentry.interfaces.Query", content);
        return json;
    }

    public static JSONObject exception(Throwable exception) {
        return Events.exception(new JSONObject(), exception);
    }

    public static JSONObject exception(JSONObject json, Throwable exception) {
        json.put("level", LogLevel.ERROR.intValue);
        json.put("culprit", Events.determineCulprit(exception));
        json.put("sentry.interfaces.Exception", Events.buildException(exception));
        json.put("sentry.interfaces.Stacktrace", Events.buildStacktrace(exception));
        return json;
    }

    public static String determineCulprit(Throwable exception) {
        String culprit = null;
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            StackTraceElement[] elements = cause.getStackTrace();
            if (elements.length <= 0) continue;
            StackTraceElement trace = elements[0];
            culprit = trace.getClassName() + "." + trace.getMethodName();
        }
        return culprit;
    }

    public static JSONObject buildException(Throwable exception) {
        JSONObject json = new JSONObject();
        json.put("type", exception.getClass().getSimpleName());
        json.put("value", exception.getMessage());
        json.put("module", exception.getClass().getPackage().getName());
        return json;
    }

    public static JSONObject buildStacktrace(Throwable exception) {
        JSONArray array = new JSONArray();
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            StackTraceElement[] elements = cause.getStackTrace();
            for (int index = 0; index < elements.length; ++index) {
                if (index == 0) {
                    JSONObject causedByFrame = new JSONObject();
                    String msg = "Caused by: " + cause.getClass().getName();
                    if (cause.getMessage() != null) {
                        msg = msg + " (\"" + cause.getMessage() + "\")";
                    }
                    causedByFrame.put("filename", msg);
                    causedByFrame.put("lineno", -1);
                    array.add(causedByFrame);
                }
                StackTraceElement element = elements[index];
                JSONObject frame = new JSONObject();
                frame.put("filename", element.getClassName());
                frame.put("function", element.getMethodName());
                frame.put("lineno", element.getLineNumber());
                array.add(frame);
            }
        }
        JSONObject stacktrace = new JSONObject();
        stacktrace.put("frames", array);
        return stacktrace;
    }

    public static enum LogLevel {
        ERROR(5);

        public int intValue;

        private LogLevel(int intValue) {
            this.intValue = intValue;
        }
    }
}

