/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.kencochrane.raven.AsyncTransport;
import net.kencochrane.raven.Events;
import net.kencochrane.raven.SentryDsn;
import net.kencochrane.raven.Transport;
import net.kencochrane.raven.Utils;
import net.kencochrane.raven.spi.JSONProcessor;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.time.DateFormatUtils;
import org.json.simple.JSONObject;

public class Client {
    public static final String VARIANT_ASYNC = "async";
    protected static final Map<String, Class<? extends Transport>> TRANSPORT_REGISTRY = new HashMap<String, Class<? extends Transport>>();
    private static final Logger LOG = Logger.getLogger("raven.client");
    public final SentryDsn dsn;
    protected Transport transport;
    protected boolean messageCompressionEnabled = true;
    private List<JSONProcessor> jsonProcessors = Collections.emptyList();

    public Client() {
        this(true);
    }

    public Client(boolean autoStart) {
        this(SentryDsn.buildOptional(), autoStart);
    }

    public Client(SentryDsn dsn) {
        this(dsn, true);
    }

    public Client(SentryDsn dsn, boolean autoStart) {
        this.dsn = dsn;
        if (autoStart) {
            this.start();
        }
    }

    public Client(Transport transport) {
        this(transport, true);
    }

    public Client(Transport transport, boolean autoStart) {
        this.dsn = transport.dsn;
        this.transport = transport;
        if (autoStart) {
            this.start();
        }
    }

    public synchronized void setJSONProcessors(List<JSONProcessor> processors) {
        this.jsonProcessors = new ArrayList<JSONProcessor>(processors.size());
        this.jsonProcessors.addAll(processors);
    }

    public boolean isMessageCompressionEnabled() {
        return this.messageCompressionEnabled;
    }

    public void setMessageCompressionEnabled(boolean messageCompressionEnabled) {
        this.messageCompressionEnabled = messageCompressionEnabled;
    }

    public String captureMessage(String msg) {
        return this.captureMessage(msg, null, null, null, null);
    }

    public String captureMessage(String msg, Map<String, ?> tags) {
        return this.captureMessage(msg, null, null, null, null, tags);
    }

    public String captureMessage(String message, Long timestamp, String loggerClass, Integer logLevel, String culprit) {
        return this.captureMessage(message, timestamp, loggerClass, logLevel, culprit, null);
    }

    public String captureMessage(String message, Long timestamp, String loggerClass, Integer logLevel, String culprit, Map<String, ?> tags) {
        timestamp = timestamp == null ? Utils.now() : timestamp;
        Message msg = this.buildMessage(message, this.formatTimestamp(timestamp), loggerClass, logLevel, culprit, null, tags);
        this.send(msg, timestamp);
        return msg.eventId;
    }

    public String captureException(Throwable exception) {
        long timestamp = Utils.now();
        return this.captureException(exception.getMessage(), timestamp, null, null, null, exception);
    }

    public String captureException(Throwable exception, Map<String, ?> tags) {
        long timestamp = Utils.now();
        return this.captureException(exception.getMessage(), timestamp, null, null, null, exception, tags);
    }

    public String captureException(String logMessage, long timestamp, String loggerName, Integer logLevel, String culprit, Throwable exception) {
        return this.captureException(logMessage, timestamp, loggerName, logLevel, culprit, exception, null);
    }

    public String captureException(String logMessage, long timestamp, String loggerName, Integer logLevel, String culprit, Throwable exception, Map<String, ?> tags) {
        Message message = this.buildMessage(logMessage, this.formatTimestamp(timestamp), loggerName, logLevel, culprit, exception, tags);
        this.send(message, timestamp);
        return message.eventId;
    }

    public synchronized void start() {
        if (this.isDisabled()) {
            return;
        }
        if (this.transport == null) {
            this.transport = Client.newTransport(this.dsn);
        }
        this.transport.start();
    }

    public boolean isStarted() {
        return this.transport != null && this.transport.isStarted();
    }

    public synchronized void stop() {
        if (this.transport == null) {
            return;
        }
        this.transport.stop();
        this.transport = null;
    }

    public boolean isDisabled() {
        return this.dsn == null;
    }

    protected Message buildMessage(String message, String timestamp, String loggerClass, Integer logLevel, String culprit, Throwable exception, Map<String, ?> tags) {
        if (this.isDisabled()) {
            return Message.NONE;
        }
        String eventId = this.generateEventId();
        JSONObject obj = new JSONObject();
        if (exception == null) {
            obj.put("culprit", culprit);
            Events.message(obj, message, new Object[0]);
        } else {
            Events.exception(obj, exception);
        }
        if (message == null) {
            message = exception == null ? null : exception.getMessage();
            message = message == null ? "(empty)" : message;
        }
        obj.put("event_id", eventId);
        obj.put("checksum", Client.calculateChecksum(message));
        obj.put("timestamp", timestamp);
        obj.put("message", message);
        obj.put("project", this.dsn.projectId);
        obj.put("level", logLevel == null ? Default.LOG_LEVEL : logLevel);
        obj.put("logger", loggerClass == null ? "root" : loggerClass);
        obj.put("server_name", Utils.hostname());
        if (tags != null) {
            JSONObject jsonTags = new JSONObject();
            jsonTags.putAll(tags);
            obj.put("tags", jsonTags);
        }
        for (JSONProcessor processor : this.jsonProcessors) {
            processor.process(obj, exception);
        }
        return new Message(obj, eventId, this.messageCompressionEnabled);
    }

    protected void send(Message message, long timestamp) {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.transport.send(message.encoded(), timestamp);
        }
        catch (ConnectException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected String generateEventId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected String formatTimestamp(long timestamp) {
        return DateFormatUtils.formatUTC(timestamp, DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    }

    public static Transport newTransport(SentryDsn dsn) {
        String fullScheme = dsn.getFullScheme(VARIANT_ASYNC);
        Class<? extends Transport> transportClass = TRANSPORT_REGISTRY.get(fullScheme);
        if (transportClass == null) {
            throw new InvalidConfig("No transport registered for " + fullScheme);
        }
        try {
            Constructor<? extends Transport> constructor = transportClass.getConstructor(SentryDsn.class);
            Transport transport = constructor.newInstance(dsn);
            if (dsn.isVariantIncluded(VARIANT_ASYNC)) {
                return Client.newAsyncTransport(transport);
            }
            return transport;
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfig("A transport class should contain a constructor with a SentryDsn instance as parameter", e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidConfig("Could not construct a transport layer for " + fullScheme, e);
        }
        catch (InstantiationException e) {
            throw new InvalidConfig("Could not construct a transport layer for " + fullScheme, e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConfig("Could not construct a transport layer for " + fullScheme, e);
        }
    }

    public static Transport newAsyncTransport(Transport transport) {
        Class<? extends Transport> transportClass = TRANSPORT_REGISTRY.get(VARIANT_ASYNC);
        if (transportClass == null) {
            throw new InvalidConfig("No async transport registered");
        }
        String invalidSignature = "The async transport handler should contain a public static \"build\" method with a single parameter of type " + Transport.class + " and returning a new " + Transport.class + " instance.";
        try {
            Method method = transportClass.getMethod("build", Transport.class);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new InvalidConfig(invalidSignature);
            }
            Object result = method.invoke(null, transport);
            if (!(result instanceof Transport)) {
                throw new InvalidConfig("The build method of the async transport layer should return an instance of " + Transport.class);
            }
            return (Transport)result;
        }
        catch (InvocationTargetException e) {
            throw new InvalidConfig("Could not invoke the static build method of " + transportClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfig(invalidSignature, e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConfig(invalidSignature, e);
        }
    }

    public static Class<? extends Transport> register(String scheme, Class<? extends Transport> transportClass) {
        return TRANSPORT_REGISTRY.put(scheme, transportClass);
    }

    public static void registerDefaults() {
        TRANSPORT_REGISTRY.put("http", Transport.Http.class);
        TRANSPORT_REGISTRY.put("https", Transport.Http.class);
        TRANSPORT_REGISTRY.put("naive+https", Transport.NaiveHttps.class);
        TRANSPORT_REGISTRY.put("udp", Transport.Udp.class);
        TRANSPORT_REGISTRY.put(VARIANT_ASYNC, AsyncTransport.class);
    }

    public static String sign(String message, long timestamp, String key) {
        String algo = "HmacSHA1";
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal((timestamp + " " + message).getBytes());
            return new String(Hex.encodeHex(rawHmac));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidConfig("Could not sign message: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidConfig("Could not sign message: " + e.getMessage(), e);
        }
    }

    public static String calculateChecksum(String message) {
        byte[] bytes = message.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return String.valueOf(checksum.getValue());
    }

    static {
        Client.registerDefaults();
    }

    public static class Message {
        public static final Message NONE = new Message(null, "-1", false);
        public final JSONObject json;
        public final String eventId;
        public final boolean compress;

        public Message(JSONObject json, String eventId, boolean compress) {
            this.json = json;
            this.eventId = eventId;
            this.compress = compress;
        }

        public String encoded() {
            byte[] raw = Utils.toUtf8(this.json.toJSONString());
            if (this.compress) {
                raw = Utils.compress(raw);
            }
            return Base64.encodeBase64String(raw);
        }

        public String toString() {
            return this.json.toJSONString();
        }
    }

    public static class InvalidConfig
    extends RuntimeException {
        public InvalidConfig(String msg) {
            super(msg);
        }

        public InvalidConfig(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static interface Default {
        public static final String LOGGER = "root";
        public static final int LOG_LEVEL = Events.LogLevel.ERROR.intValue;
        public static final String EMPTY_MESSAGE = "(empty)";
    }
}

