/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kencochrane.raven.Transport;

public abstract class AsyncTransport
extends Transport {
    public static final long WAIT_FOR_SHUTDOWN = 3000L;
    private static final Logger LOG = Logger.getLogger("raven.transport");
    public final Transport transport;
    protected final BlockingQueue<Message> queue;
    protected final Thread workerThread;

    public AsyncTransport(Transport transport, BlockingQueue<Message> queue) {
        super(transport.dsn);
        this.transport = transport;
        this.queue = queue;
        this.workerThread = new Thread(new Worker(this));
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public void start() {
        String name = "Raven-" + this.workerThread.getName();
        LOG.log(Level.FINE, "Starting thread " + name);
        this.workerThread.setDaemon(true);
        this.workerThread.setName(name);
        this.workerThread.start();
        super.start();
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        super.stop();
        this.workerThread.interrupt();
        try {
            this.workerThread.join(3000L);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void send(String messageBody, long timestamp) throws IOException {
        throw new UnsupportedOperationException("You probably need a subclass of " + AsyncTransport.class);
    }

    public static AsyncTransport build(Transport transport) {
        int capacity = transport.dsn.getOptionAsInt("raven.capacity", -1);
        boolean waitWhenFull = transport.dsn.getOptionAsBoolean("raven.waitWhenFull", false);
        return AsyncTransport.build(transport, waitWhenFull, capacity);
    }

    public static AsyncTransport build(Transport transport, boolean waitWhenFull, int capacity) {
        LinkedBlockingDeque<Message> queue = null;
        queue = capacity < 0 ? new LinkedBlockingDeque<Message>() : new LinkedBlockingDeque(capacity);
        if (waitWhenFull) {
            return new WaitingAsyncTransport(transport, queue);
        }
        return new LossyAsyncTransport(transport, queue);
    }

    public class Worker
    implements Runnable {
        public final AsyncTransport transport;

        public Worker(AsyncTransport transport) {
            this.transport = transport;
        }

        @Override
        public void run() {
            while (this.transport.isStarted()) {
                try {
                    Message m = this.transport.queue.take();
                    this.transport.transport.send(m.messageBody, m.timestamp);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            for (Message m : this.transport.queue) {
                try {
                    this.transport.transport.send(m.messageBody, m.timestamp);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    public static class Message {
        public final String messageBody;
        public final long timestamp;

        public Message(String messageBody, long timestamp) {
            this.messageBody = messageBody;
            this.timestamp = timestamp;
        }
    }

    public static class LossyAsyncTransport
    extends AsyncTransport {
        public LossyAsyncTransport(Transport transport, BlockingQueue<Message> queue) {
            super(transport, queue);
        }

        @Override
        public void send(String messageBody, long timestamp) throws IOException {
            try {
                this.queue.add(new Message(messageBody, timestamp));
            }
            catch (IllegalStateException e) {
                throw new IOException(e);
            }
        }
    }

    public static class WaitingAsyncTransport
    extends AsyncTransport {
        public WaitingAsyncTransport(Transport transport, BlockingQueue<Message> queue) {
            super(transport, queue);
        }

        @Override
        public void send(String messageBody, long timestamp) throws IOException {
            try {
                this.queue.put(new Message(messageBody, timestamp));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static interface Option {
        public static final String WAIT_WHEN_FULL = "raven.waitWhenFull";
        public static final boolean WAIT_WHEN_FULL_DEFAULT = false;
        public static final String CAPACITY = "raven.capacity";
    }
}

