/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.getsentry;

import net.kencochrane.raven.DefaultRavenFactory;
import net.kencochrane.raven.connection.Connection;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.getsentry.connection.GetSentryHttpsConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSentryRavenFactory
extends DefaultRavenFactory {
    private static final Logger logger = LoggerFactory.getLogger(GetSentryRavenFactory.class);

    protected Connection createConnection(Dsn dsn) {
        Connection connection;
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("getsentry")) {
            logger.info("Using an HTTP connection to Sentry.");
            connection = this.createHttpConnection(dsn);
            if (!Boolean.FALSE.toString().equalsIgnoreCase((String)dsn.getOptions().get("raven.async"))) {
                connection = this.createAsyncConnection(dsn, connection);
            }
        } else {
            connection = super.createConnection(dsn);
        }
        return connection;
    }

    protected Connection createHttpConnection(Dsn dsn) {
        GetSentryHttpsConnection httpConnection = new GetSentryHttpsConnection(dsn.getProjectId(), dsn.getPublicKey(), dsn.getSecretKey());
        httpConnection.setMarshaller(this.createMarshaller(dsn));
        if (dsn.getOptions().containsKey("raven.timeout")) {
            httpConnection.setTimeout(Integer.parseInt((String)dsn.getOptions().get("raven.timeout")));
        }
        return httpConnection;
    }
}

