/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.ugiggle.trello;

import com.julienvey.trello.Trello;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Card;
import java.util.stream.Stream;
import net.kemitix.ugiggle.trello.Attachment;
import net.kemitix.ugiggle.trello.AttachmentDirectory;
import net.kemitix.ugiggle.trello.TrelloAttachment;

public class TrelloCard {
    private final Card tcard;
    private final Trello trello;
    private AttachmentDirectory attachmentDir;

    private TrelloCard(Card tcard, Trello trello, AttachmentDirectory attachmentDir) {
        this.tcard = tcard;
        this.trello = trello;
        this.attachmentDir = attachmentDir;
    }

    public static TrelloCard create(Card tcard, Trello trello, AttachmentDirectory attachmentDir) {
        return new TrelloCard(tcard, trello, attachmentDir);
    }

    public Stream<Attachment> findAttachments() {
        return this.trello.getCardAttachments(this.tcard.getId(), new Argument[0]).stream().map(attachment -> TrelloAttachment.create(attachment, this.tcard, this.attachmentDir));
    }

    public String getName() {
        return this.tcard.getName();
    }
}

