/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.ugiggle.trello;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import net.kemitix.ugiggle.trello.AttachmentDirectory;

@ApplicationScoped
public class AttachmentDirectoryImpl
implements AttachmentDirectory {
    private static final Logger LOG = Logger.getLogger(AttachmentDirectoryImpl.class.getName());
    private Path dir;
    private List<File> toDelete = new ArrayList<File>();

    @PostConstruct
    void init() throws IOException {
        this.dir = Files.createTempDirectory("attachments", new FileAttribute[0]);
        LOG.info("Attachments directory: " + this.dir);
    }

    @Override
    public File createFile(File fileName) {
        File file = this.dir.resolve(fileName.getName()).toFile();
        LOG.info("Created attachment: " + file);
        this.toDelete.add(file);
        return file;
    }

    @PreDestroy
    public void deleteFiles() {
        this.toDelete.stream().peek(file -> LOG.info("Deleting: " + file)).map(File::delete).filter(deleted -> deleted == false).forEach(r -> LOG.warning("Could not delete file"));
        if (this.dir.toFile().delete()) {
            LOG.info("Deleted directory: " + this.dir);
        } else {
            LOG.warning("Could not delete directory: " + this.dir);
        }
    }
}

