/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.ugiggle.trello;

import com.julienvey.trello.Trello;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Board;
import com.julienvey.trello.domain.Card;
import com.julienvey.trello.domain.TList;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import net.kemitix.ugiggle.service.AttachmentDirectory;
import net.kemitix.ugiggle.service.ReadingListService;
import net.kemitix.ugiggle.service.Submission;
import net.kemitix.ugiggle.service.UGiggleConfig;
import net.kemitix.ugiggle.trello.TrelloCard;

@ApplicationScoped
public class TrelloSubmissionService
implements ReadingListService {
    private static final Logger LOG = Logger.getLogger(TrelloSubmissionService.class.getName());
    @Inject
    UGiggleConfig config;
    @Inject
    Trello trello;
    @Inject
    AttachmentDirectory attachmentDir;

    public Stream<? extends Submission> getReadingList() {
        String board = this.config.getSlushBoard();
        String list = this.config.getSlushList();
        return this.findBoard(board).flatMap(b -> this.findLists((Board)b, list)).flatMap(this::findCards).takeWhile(this::isNotTarget).map(card -> TrelloCard.create(card, this.trello, this.attachmentDir));
    }

    private Stream<Board> findBoard(String name) {
        LOG.info("Find board: " + name);
        return this.trello.getMemberBoards("me", new Argument[0]).stream().filter(board -> name.equals(board.getName())).peek(board -> LOG.info("Board: " + board.getName()));
    }

    private Stream<TList> findLists(Board board, String name) {
        LOG.info("Find list: " + name);
        return this.trello.getBoardLists(board.getId(), new Argument[0]).stream().filter(tList -> name.equals(tList.getName())).peek(list -> LOG.info("List: " + list.getName()));
    }

    private Stream<Card> findCards(TList tList) {
        LOG.info("Find cards");
        return this.trello.getListCards(tList.getId(), new Argument[0]).stream().peek(card -> LOG.info("Card: " + card.getName()));
    }

    private boolean isNotTarget(Card card) {
        return !this.config.getTargetName().equals(card.getName());
    }
}

