/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.ugiggle.trello;

import com.julienvey.trello.domain.Card;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import net.kemitix.ugiggle.service.Attachment;
import net.kemitix.ugiggle.service.AttachmentDirectory;
import net.kemitix.ugiggle.service.LocalAttachment;

public class TrelloAttachment
implements Attachment {
    private static final Logger LOG = Logger.getLogger(TrelloAttachment.class.getName());
    private static final String[] EXTENSIONS = new String[]{"doc", "docx", "odt"};
    private static final AtomicInteger SEQUENCE_COUNTER = new AtomicInteger();
    private final com.julienvey.trello.domain.Attachment attachment;
    private final Card card;
    private final AttachmentDirectory attachmentDirectory;
    private final int sequence;

    private TrelloAttachment(com.julienvey.trello.domain.Attachment attachment, Card card, AttachmentDirectory attachmentDirectory) {
        this.attachment = attachment;
        this.card = card;
        this.attachmentDirectory = attachmentDirectory;
        this.sequence = SEQUENCE_COUNTER.incrementAndGet();
    }

    public static Attachment create(com.julienvey.trello.domain.Attachment attachment, Card card, AttachmentDirectory dir) {
        return new TrelloAttachment(attachment, card, dir);
    }

    public File getFileName() {
        return new File(String.format("%2d - %s.%s", this.sequence, this.card.getName(), this.extension()));
    }

    private String extension() {
        URI uri = URI.create(this.attachment.getUrl());
        String path = uri.getPath();
        for (String ex : EXTENSIONS) {
            if (!path.endsWith("." + ex)) continue;
            return ex;
        }
        return "";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Attachment download() {
        try (ReadableByteChannel source = Channels.newChannel(this.getUrl().openStream());){
            LocalAttachment localAttachment;
            block14: {
                File file = this.attachmentDirectory.createFile(this.getFileName());
                LOG.info("Downloading to " + file.getCanonicalPath());
                FileChannel channel = new FileOutputStream(file).getChannel();
                try {
                    channel.transferFrom(source, 0L, Long.MAX_VALUE);
                    localAttachment = new LocalAttachment(file);
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return localAttachment;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URL getUrl() throws MalformedURLException {
        return URI.create(this.attachment.getUrl()).toURL();
    }
}

