/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.ugiggle.trello;

import com.julienvey.trello.Trello;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Card;
import java.util.stream.Stream;
import net.kemitix.ugiggle.service.Attachment;
import net.kemitix.ugiggle.service.Submission;
import net.kemitix.ugiggle.service.UGiggleConfig;
import net.kemitix.ugiggle.trello.TrelloAttachment;

public class TrelloCard
implements Submission {
    private final Card tcard;
    private final Trello trello;
    private final UGiggleConfig config;

    private TrelloCard(Card tcard, Trello trello, UGiggleConfig config) {
        this.tcard = tcard;
        this.trello = trello;
        this.config = config;
    }

    public static TrelloCard create(Card tcard, Trello trello, UGiggleConfig config) {
        return new TrelloCard(tcard, trello, config);
    }

    public Stream<Attachment> findAttachments() {
        return this.trello.getCardAttachments(this.tcard.getId(), new Argument[0]).stream().map(attachment -> TrelloAttachment.create(attachment, this.tcard));
    }

    public String getName() {
        return this.tcard.getName();
    }
}

