/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.ugiggle.trello;

import com.julienvey.trello.domain.Card;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.kemitix.ugiggle.service.Attachment;

public class TrelloAttachment
implements Attachment {
    private static final String[] EXTENSIONS = new String[]{"doc", "docx", "odt"};
    private final com.julienvey.trello.domain.Attachment attachment;
    private final Card card;

    private TrelloAttachment(com.julienvey.trello.domain.Attachment attachment, Card card) {
        this.attachment = attachment;
        this.card = card;
    }

    public static Attachment create(com.julienvey.trello.domain.Attachment attachment, Card card) {
        return new TrelloAttachment(attachment, card);
    }

    public File getFileName() {
        return new File(String.format("%s.%s", this.card.getName(), this.extension()));
    }

    private String extension() {
        URI uri = URI.create(this.attachment.getUrl());
        String path = uri.getPath();
        for (String ex : EXTENSIONS) {
            if (!path.endsWith("." + ex)) continue;
            return ex;
        }
        return "";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File download() {
        try (ReadableByteChannel source = Channels.newChannel(this.getUrl().openStream());){
            File file;
            block14: {
                File file2 = Files.createTempFile("trello", "attachment", new FileAttribute[0]).toFile();
                FileChannel channel = new FileOutputStream(file2).getChannel();
                try {
                    channel.transferFrom(source, 0L, Long.MAX_VALUE);
                    file = file2;
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URL getUrl() throws MalformedURLException {
        return URI.create(this.attachment.getUrl()).toURL();
    }
}

