/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.text.fit;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kemitix.text.fit.WordWrapper;

class TextLineWrapImpl
implements WordWrapper {
    TextLineWrapImpl() {
    }

    @Override
    public List<String> wrap(String text, Font font, Graphics2D graphics2D, int width) {
        String source = String.join((CharSequence)" ", text.split("\n"));
        List<Word> words = this.wordLengths(source.split(" "), font, graphics2D);
        return this.wrapWords(words, width);
    }

    private List<String> wrapWords(List<Word> words, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        int end = 0;
        ArrayList<String> line = new ArrayList<String>();
        for (Word word : words) {
            if (end + word.width > width) {
                lines.add(String.join((CharSequence)" ", line));
                line.clear();
                end = 0;
            }
            line.add(word.word);
            end += word.width;
        }
        lines.add(String.join((CharSequence)" ", line));
        return lines.stream().filter(l -> l.length() > 0).collect(Collectors.toList());
    }

    private List<Word> wordLengths(String[] words, Font font, Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return Arrays.stream(words).map(word -> new Word((String)word, font, fontRenderContext)).collect(Collectors.toList());
    }

    private static class Word {
        private final String word;
        private final int width;

        public Word(String word, Font font, FontRenderContext fontRenderContext) {
            this.word = word;
            Rectangle2D stringBounds = font.getStringBounds(word + " ", fontRenderContext);
            this.width = Double.valueOf(stringBounds.getWidth()).intValue();
        }
    }
}

