/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.text.fit;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kemitix.text.fit.BoxFitter;
import net.kemitix.text.fit.WordWrapper;

class BoxFitterImpl
implements BoxFitter {
    private final WordWrapper wordWrapper;

    @Override
    public int fit(String text, Function<Integer, Font> fontFactory, Graphics2D graphics2D, Rectangle2D box) {
        int fit = this.fitMinMax(0, (int)box.getHeight(), new FitEnvironment(text, fontFactory, graphics2D, box));
        if (fit <= 2) {
            throw new IllegalArgumentException("The text is too long to fit");
        }
        return fit;
    }

    private Integer fitMinMax(int min, int max, FitEnvironment e) {
        List<String> lines;
        int mid = (max + min) / 2;
        if (mid == min) {
            return mid;
        }
        Font font = e.getFont(mid);
        List<Rectangle2D> lineSizes = this.lineSizes(font, lines = this.wrapLines(font, e), e.fontRenderContext());
        if (this.sumLineHeights(lineSizes) > e.boxHeight() || this.maxLineWidth(lineSizes) > e.boxWidth()) {
            return this.fitMinMax(min, mid, e);
        }
        return this.fitMinMax(mid, max, e);
    }

    private List<String> wrapLines(Font font, FitEnvironment e) {
        return this.wordWrapper.wrap(e.text, font, e.graphics2D, e.boxWidth());
    }

    private List<Rectangle2D> lineSizes(Font font, List<String> lines, FontRenderContext renderContext) {
        return lines.stream().map(line -> font.getStringBounds(line.strip(), renderContext)).collect(Collectors.toList());
    }

    private int sumLineHeights(List<Rectangle2D> lineSizes) {
        return lineSizes.stream().map(RectangularShape::getHeight).mapToInt(Double::intValue).sum();
    }

    private int maxLineWidth(List<Rectangle2D> lineSizes) {
        return lineSizes.stream().map(RectangularShape::getWidth).mapToInt(Double::intValue).max().orElse(0);
    }

    public BoxFitterImpl(WordWrapper wordWrapper) {
        this.wordWrapper = wordWrapper;
    }

    private static class FitEnvironment {
        private final String text;
        private final Function<Integer, Font> fontFactory;
        private final Graphics2D graphics2D;
        private final Rectangle2D box;

        public Font getFont(int size) {
            return this.fontFactory.apply(size);
        }

        public int boxWidth() {
            return (int)this.box.getWidth();
        }

        public int boxHeight() {
            return (int)this.box.getHeight();
        }

        public FontRenderContext fontRenderContext() {
            return this.graphics2D.getFontRenderContext();
        }

        public FitEnvironment(String text, Function<Integer, Font> fontFactory, Graphics2D graphics2D, Rectangle2D box) {
            this.text = text;
            this.fontFactory = fontFactory;
            this.graphics2D = graphics2D;
            this.box = box;
        }
    }
}

