/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.spring.common.logging;

import java.lang.reflect.Field;
import java.util.logging.Logger;
import net.kemitix.spring.common.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class LoggerPostProcessor
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            if (field.getAnnotation(Log.class) != null) {
                Logger logger = Logger.getLogger(bean.getClass().getName());
                field.set(bean, logger);
            }
        });
        return bean;
    }
}

