/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.spring.common.logging;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class PropertyLogger {
    public void logProperties(Logger logger, Object subject) {
        ArrayList propertyNames = new ArrayList();
        ReflectionUtils.doWithFields(subject.getClass(), field -> propertyNames.add(field.getName()), field -> !Modifier.isPrivate(field.getModifiers()));
        int maxLength = 0;
        for (String propertyName2 : propertyNames) {
            if (propertyName2.length() <= maxLength) continue;
            maxLength = propertyName2.length();
        }
        String nameFormat = String.format("%%%ds", maxLength);
        propertyNames.stream().forEach(propertyName -> {
            try {
                logger.log(Level.INFO, "{0} : {1}", new Object[]{String.format(nameFormat, propertyName), ReflectionUtils.findField(subject.getClass(), (String)propertyName).get(subject)});
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(PropertyLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }
}

