/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.wrapper.printstream;

import java.io.PrintStream;
import java.util.function.Predicate;
import lombok.NonNull;
import net.kemitix.wrapper.printstream.PassthroughPrintStreamWrapper;

class StringFilterPrintStreamWrapper
extends PassthroughPrintStreamWrapper {
    private final Predicate<String> predicate;

    StringFilterPrintStreamWrapper(PrintStream core, @NonNull Predicate<String> predicate) {
        super(core);
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        this.predicate = predicate;
    }

    @Override
    public final void print(String s) {
        if (this.predicate.test(s)) {
            super.print(s);
        }
    }

    @Override
    public final void println(String s) {
        if (this.predicate.test(s)) {
            super.println(s);
        }
    }
}

