/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven.digraph;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.kemitix.pdg.maven.DotFileFormat;
import net.kemitix.pdg.maven.digraph.AbstractGraphElement;
import net.kemitix.pdg.maven.digraph.ElementContainer;
import net.kemitix.pdg.maven.digraph.GraphElement;
import net.kemitix.pdg.maven.digraph.NodeProperties;
import net.kemitix.pdg.maven.digraph.PropertyElement;

@Immutable
public class Digraph
extends AbstractGraphElement
implements ElementContainer {
    private final List<GraphElement> elements = new ArrayList<GraphElement>();

    public Digraph(DotFileFormat dotFileFormat) {
        super(dotFileFormat);
    }

    @Override
    public final boolean add(GraphElement graphElement) {
        return this.elements.add(graphElement);
    }

    @Override
    public final String render() {
        return this.getDotFileFormat().render(this);
    }

    public List<GraphElement> getElements() {
        return this.elements;
    }

    public static class Builder {
        private final DotFileFormat dotFileFormat;

        public Builder(DotFileFormat dotFileFormat) {
            this.dotFileFormat = dotFileFormat;
        }

        public final Digraph build() {
            Digraph digraph = new Digraph(this.dotFileFormat);
            digraph.add(new PropertyElement("compound", "true", this.dotFileFormat));
            NodeProperties nodeProperties = new NodeProperties(this.dotFileFormat);
            nodeProperties.add(new PropertyElement("shape", "box", this.dotFileFormat));
            digraph.add(nodeProperties);
            return digraph;
        }
    }
}

