/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.kemitix.node.Node;
import net.kemitix.node.Nodes;
import net.kemitix.pdg.maven.DependencyData;
import net.kemitix.pdg.maven.PackageData;
import org.apache.maven.plugin.logging.Log;

@Immutable
final class NodeTreeDependencyData
implements DependencyData {
    private final Node<PackageData> root = Nodes.namedRoot((Object)PackageData.newInstance("[root]"), (String)"root");
    private final Node<PackageData> baseNode;

    private NodeTreeDependencyData(String basePackage) {
        List<PackageData> baseLine = this.createPackageLineList(basePackage);
        this.root.createDescendantLine(baseLine);
        this.baseNode = this.root.findInPath(baseLine).orElse(null);
    }

    static DependencyData newInstance(String basePackage) {
        return new NodeTreeDependencyData(basePackage);
    }

    @Override
    public void addDependency(String user, String imported) {
        List<PackageData> userLine = this.createPackageLineList(user);
        this.root.createDescendantLine(userLine);
        List<PackageData> importedLine = this.createPackageLineList(imported);
        this.root.createDescendantLine(importedLine);
        this.root.findInPath(importedLine).ifPresent(i -> this.root.findInPath(userLine).ifPresent(u -> u.findData().ifPresent(d -> d.uses((Node<PackageData>)i))));
    }

    @Override
    public void debugLog(Log log) {
        this.debugLogNode(log, this.baseNode, 0);
    }

    @Override
    public void updateNames() {
        this.baseNode.stream().forEach(node -> node.setName(((PackageData)node.getData()).getName()));
    }

    private List<PackageData> createPackageLineList(String userPackage) {
        ArrayList<PackageData> line = new ArrayList<PackageData>();
        Arrays.asList(userPackage.split("\\.")).forEach(n -> line.add(PackageData.newInstance(n)));
        return line;
    }

    private void debugLogNode(Log log, Node<PackageData> node, int depth) {
        String padding = IntStream.range(0, depth * 2).mapToObj(x -> " ").collect(Collectors.joining());
        node.findData().map(PackageData::getName).map(name -> padding + name).ifPresent(arg_0 -> ((Log)log).info(arg_0));
        node.getChildren().forEach(t -> this.debugLogNode(log, (Node<PackageData>)t, depth + 1));
    }

    @Override
    public Node<PackageData> getBaseNode() {
        return this.baseNode;
    }
}

