/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import net.kemitix.node.Node;
import net.kemitix.pdg.maven.AbstractDotFileFormat;
import net.kemitix.pdg.maven.GraphFilter;
import net.kemitix.pdg.maven.NodePathGenerator;
import net.kemitix.pdg.maven.PackageData;
import net.kemitix.pdg.maven.digraph.EdgeElement;
import net.kemitix.pdg.maven.digraph.GraphElement;
import net.kemitix.pdg.maven.digraph.NodeElement;
import net.kemitix.pdg.maven.digraph.Subgraph;

@Immutable
class DotFileFormatSimple
extends AbstractDotFileFormat {
    public static final String NEWLINE = System.lineSeparator();

    DotFileFormatSimple(Node<PackageData> base, NodePathGenerator nodePathGenerator, GraphFilter graphFilter) {
        super(base, nodePathGenerator, graphFilter);
    }

    @Override
    public String render(Subgraph subgraph) {
        String id = subgraph.getId();
        String node = "";
        if (!id.startsWith("_")) {
            node = this.quoted(id) + NEWLINE;
        }
        return node + subgraph.getElements().stream().map(GraphElement::render).collect(Collectors.joining(NEWLINE));
    }

    @Override
    public String render(NodeElement nodeElement) {
        return this.quoted(nodeElement.getId());
    }

    @Override
    public String render(EdgeElement edgeElement) {
        return this.quoted(edgeElement.getTail().getId()) + " -> " + this.quoted(edgeElement.getHead().getId());
    }
}

