/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.kemitix.node.Node;
import net.kemitix.pdg.maven.AbstractDotFileFormat;
import net.kemitix.pdg.maven.GraphFilter;
import net.kemitix.pdg.maven.NodePathGenerator;
import net.kemitix.pdg.maven.PackageData;
import net.kemitix.pdg.maven.digraph.EdgeElement;
import net.kemitix.pdg.maven.digraph.NodeElement;
import net.kemitix.pdg.maven.digraph.Subgraph;

@Immutable
class DotFileFormatNested
extends AbstractDotFileFormat {
    private static final String LINE = System.lineSeparator();

    DotFileFormatNested(Node<PackageData> base, NodePathGenerator nodePathGenerator, GraphFilter graphFilter) {
        super(base, nodePathGenerator, graphFilter);
    }

    private void addAnyLHead(Node<PackageData> headNode, Node<PackageData> tailNode, List<String> attributes) {
        if (this.hasChildren(headNode) && this.isNotDescendant(headNode, tailNode)) {
            attributes.add(String.format("lhead=\"cluster%s\"", this.getClusterId(headNode)));
        }
    }

    private void addAnyLTail(Node<PackageData> tailNode, Node<PackageData> headNode, List<String> attributes) {
        if (this.hasChildren(tailNode) && this.isNotDescendant(tailNode, headNode)) {
            attributes.add(String.format("ltail=\"cluster%s\"", this.getClusterId(tailNode)));
        }
    }

    private boolean isNotDescendant(Node<PackageData> childNode, Node<PackageData> parentNode) {
        return !parentNode.isDescendantOf(childNode);
    }

    private boolean hasChildren(Node<PackageData> packageDataNode) {
        return !packageDataNode.getChildren().isEmpty();
    }

    private String buildAttributeTag(List<String> attributes) {
        String attributeTag = "";
        if (attributes.size() > 0) {
            attributeTag = String.format("[%s]", String.join((CharSequence)",", attributes));
        }
        return attributeTag;
    }

    @Override
    public String render(Subgraph subgraph) {
        String label = this.quoted(subgraph.getLabel());
        String id = this.quoted(subgraph.getId());
        return String.format("subgraph %s{" + LINE + "label=%s" + LINE + "%s[label=\"\",style=\"invis\",width=0]" + LINE + "%s" + LINE + "}", this.quoted("cluster" + subgraph.getId()), label, id, this.renderElements(subgraph.getElements()));
    }

    @Override
    public String render(EdgeElement edgeElement) {
        ArrayList<String> attributes = new ArrayList<String>();
        Node<PackageData> tailNode = edgeElement.getTail().getPackageDataNode();
        Node<PackageData> headNode = edgeElement.getHead().getPackageDataNode();
        this.addAnyLTail(tailNode, headNode, attributes);
        this.addAnyLHead(headNode, tailNode, attributes);
        String attributeTag = this.buildAttributeTag(attributes);
        return String.format("%s->%s%s", this.quoted(this.getNodeId(tailNode)), this.quoted(this.getNodeId(headNode)), attributeTag);
    }

    @Override
    public final String render(NodeElement nodeElement) {
        String label;
        String id = nodeElement.getId();
        if (id.equals(label = nodeElement.getLabel())) {
            return this.quoted(id);
        }
        return this.quoted(id) + "[label=" + this.quoted(label) + "]";
    }
}

