/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.File;
import java.util.List;
import net.kemitix.pdg.maven.DefaultNodePathGenerator;
import net.kemitix.pdg.maven.DigraphModule;
import net.kemitix.pdg.maven.DigraphService;
import net.kemitix.pdg.maven.GraphFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="digraph", aggregator=true)
public class DigraphMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> projects;
    @Parameter(defaultValue="${project.outputDirectory}")
    private File outputDirectory;
    @Parameter(name="includeTests", defaultValue="false")
    private boolean includeTests;
    @Parameter(name="basePackage", required=true)
    private String basePackage;
    @Parameter(name="debug", defaultValue="true")
    private boolean debug;
    @Parameter(name="format", defaultValue="nested")
    private String format;
    @Parameter(name="exclude")
    private String exclude;
    @Parameter(name="include")
    private String include;

    public final void execute() {
        GraphFilter graphFilter = GraphFilter.of(this.exclude, this.include, new DefaultNodePathGenerator());
        DigraphModule digraphModule = new DigraphModule(this, graphFilter);
        ((DigraphService)Guice.createInjector((Module[])new Module[]{digraphModule}).getInstance(DigraphService.class)).execute(this);
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProjects(List<MavenProject> projects) {
        this.projects = projects;
    }

    public List<MavenProject> getProjects() {
        return this.projects;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isIncludeTests() {
        return this.includeTests;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setInclude(String include) {
        this.include = include;
    }
}

