/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.kemitix.node.Node;
import net.kemitix.node.Nodes;
import net.kemitix.pdg.maven.GraphFilter;
import net.kemitix.pdg.maven.NodePathGenerator;
import net.kemitix.pdg.maven.PackageData;
import net.kemitix.pdg.maven.TreeFilter;

class DefaultTreeFilter
implements TreeFilter {
    private final GraphFilter graphFilter;
    private final NodePathGenerator nodePathGenerator;

    @Inject
    DefaultTreeFilter(GraphFilter graphFilter, NodePathGenerator nodePathGenerator) {
        this.graphFilter = graphFilter;
        this.nodePathGenerator = nodePathGenerator;
    }

    @Override
    public Node<PackageData> filterTree(Node<PackageData> root) {
        Set<Node<PackageData>> selected = root.stream().filter(this.graphFilter::filterNodes).collect(Collectors.toSet());
        List<Node<PackageData>> validNodes = Stream.concat(selected.stream(), Stream.concat(this.used(selected), this.users(root, selected))).distinct().flatMap(node -> Stream.concat(Stream.of(node), node.parentStream())).distinct().collect(Collectors.toList());
        Node<PackageData> duplicateTree = this.duplicateNode(root, validNodes);
        this.fixUpUses(duplicateTree, root);
        return duplicateTree;
    }

    private void fixUpUses(Node<PackageData> target, Node<PackageData> root) {
        Map<String, Node<PackageData>> targetMap = target.stream().collect(this.nodeMapCollector(target));
        target.stream().map(Node::getData).forEach(data -> data.setUses(data.getUses().stream().map(use -> this.packageName(root, (Node<PackageData>)use)).filter(targetMap::containsKey).map(targetMap::get).collect(Collectors.toSet())));
        target.stream().forEach(node -> node.setName(((PackageData)node.getData()).getName()));
    }

    private String packageName(Node<PackageData> root, Node<PackageData> use) {
        return this.nodePathGenerator.getPath(use, root, ".");
    }

    private Collector<Node<PackageData>, ?, Map<String, Node<PackageData>>> nodeMapCollector(Node<PackageData> legacy) {
        return Collectors.toMap(node -> this.packageName(legacy, (Node<PackageData>)node), Function.identity());
    }

    private Stream<Node<PackageData>> users(Node<PackageData> root, Set<Node<PackageData>> included) {
        return root.stream().flatMap(node -> ((PackageData)node.getData()).getUses().stream().filter(included::contains).map(usedNode -> node)).filter(node -> !this.graphFilter.isExcluded((Node<PackageData>)node));
    }

    private Stream<Node<PackageData>> used(Set<Node<PackageData>> included) {
        return included.stream().flatMap(node -> ((PackageData)node.getData()).getUses().stream().filter(use -> !this.graphFilter.isExcluded((Node<PackageData>)use)));
    }

    private Node<PackageData> duplicateNode(Node<PackageData> source, List<Node<PackageData>> eligible) {
        Node duplicate = Nodes.namedRoot(null, (String)source.getName());
        duplicate.setData(source.getData());
        source.getChildren().stream().filter(eligible::contains).map(child -> this.duplicateNode((Node<PackageData>)child, eligible)).forEach(arg_0 -> ((Node)duplicate).addChild(arg_0));
        return duplicate;
    }
}

