/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import net.kemitix.pdg.maven.DigraphMojo;
import net.kemitix.pdg.maven.SourceFileProvider;
import net.kemitix.pdg.maven.SourceFileVisitor;

@Immutable
class DefaultSourceFileProvider
implements SourceFileProvider {
    private final SourceFileVisitor fileVisitor;
    private final DigraphMojo mojo;

    @Inject
    DefaultSourceFileProvider(SourceFileVisitor fileVisitor, DigraphMojo mojo) {
        this.fileVisitor = fileVisitor;
        this.mojo = mojo;
    }

    @Override
    public List<File> process(List<String> directories) {
        directories.forEach(dir -> {
            try {
                Path start = new File((String)dir).getAbsoluteFile().toPath();
                Files.walkFileTree(start, this.fileVisitor);
            }
            catch (IOException ex) {
                this.mojo.getLog().error((Throwable)ex);
            }
        });
        return this.fileVisitor.getJavaFiles();
    }
}

