/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import net.kemitix.pdg.maven.DependencyData;
import net.kemitix.pdg.maven.DigraphMojo;
import net.kemitix.pdg.maven.SourceFileAnalyser;

@Immutable
class DefaultSourceFileAnalyser
implements SourceFileAnalyser {
    private static final Pattern METHOD_IMPORT = Pattern.compile("^(?<package>.+)\\.(?<class>.+)\\.(?<method>.+)");
    private static final Pattern CLASS_IMPORT = Pattern.compile("^(?<package>.+)\\.(?<class>.+)");
    private final DigraphMojo mojo;

    @Inject
    DefaultSourceFileAnalyser(DigraphMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void analyse(DependencyData dependencyData, InputStream inputStream) {
        try {
            CompilationUnit cu = JavaParser.parse((InputStream)inputStream);
            cu.getPackageDeclaration().ifPresent(pd -> this.analyseUnit((PackageDeclaration)pd, cu, dependencyData));
        }
        catch (ParseProblemException ex) {
            this.mojo.getLog().error((CharSequence)("Error parsing file " + inputStream), (Throwable)ex);
        }
    }

    private void analyseUnit(PackageDeclaration aPackage, CompilationUnit cu, DependencyData dependencyData) {
        String packageName = aPackage.getName().toString();
        cu.getImports().forEach(id -> {
            String name = id.getName().toString();
            Matcher m = id.isStatic() && !id.isAsterisk() ? METHOD_IMPORT.matcher(name) : CLASS_IMPORT.matcher(name);
            if (m.find()) {
                dependencyData.addDependency(packageName, m.group("package"));
            }
        });
    }
}

