/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.kemitix.pdg.maven.SourceDirectoryProvider;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;

@Immutable
class DefaultSourceDirectoryProvider
implements SourceDirectoryProvider {
    DefaultSourceDirectoryProvider() {
    }

    @Override
    public List<String> getDirectories(List<MavenProject> projects, boolean includeTests) {
        ArrayList<String> directories = new ArrayList<String>();
        projects.forEach(project -> this.addProject((List<String>)directories, (MavenProject)project, includeTests));
        return directories;
    }

    private void addProject(List<String> directories, MavenProject project, boolean includeTests) {
        Build build = project.getBuild();
        this.addDirectoryIfExists(directories, build.getSourceDirectory());
        if (includeTests) {
            this.addDirectoryIfExists(directories, build.getTestSourceDirectory());
        }
    }

    private void addDirectoryIfExists(List<String> directories, String directory) {
        if (directory != null && this.isDirectory(directory)) {
            directories.add(directory);
        }
    }

    private boolean isDirectory(String directory) {
        return Paths.get(directory, new String[0]).toFile().isDirectory();
    }
}

