/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.util.Objects;
import lombok.NonNull;
import net.kemitix.node.Node;
import net.kemitix.pdg.maven.GraphFilter;
import net.kemitix.pdg.maven.NodePathGenerator;
import net.kemitix.pdg.maven.PackageData;

class DefaultGraphFilter
implements GraphFilter {
    public static final String DELIMITER = ".";
    private final String exclude;
    private final String include;
    private final NodePathGenerator nodePathGenerator;

    DefaultGraphFilter(String exclude, String include, NodePathGenerator nodePathGenerator) {
        this.exclude = exclude == null ? "" : exclude;
        this.include = include == null ? "" : include;
        this.nodePathGenerator = nodePathGenerator;
    }

    @Override
    public boolean filterNodes(Node<PackageData> packageDataNode) {
        boolean result = true;
        String packageName = this.getPackageName(packageDataNode);
        if (!this.include.isEmpty()) {
            result = packageName.contains(this.include);
        }
        if (result && !this.exclude.isEmpty()) {
            result = !packageName.contains(this.exclude);
        }
        return result;
    }

    @Override
    public boolean isExcluded(@NonNull Node<PackageData> packageDataNode) {
        if (packageDataNode == null) {
            throw new NullPointerException("packageDataNode is marked @NonNull but is null");
        }
        Objects.requireNonNull(this.exclude);
        return !this.exclude.isEmpty() && this.getPackageName(packageDataNode).contains(this.exclude);
    }

    @Override
    public boolean isIncluded(@NonNull Node<PackageData> packageDataNode) {
        if (packageDataNode == null) {
            throw new NullPointerException("packageDataNode is marked @NonNull but is null");
        }
        Objects.requireNonNull(this.include);
        return this.include.isEmpty() || this.getPackageName(packageDataNode).contains(this.include);
    }

    private String getPackageName(Node<PackageData> packageDataNode) {
        Objects.requireNonNull(this.nodePathGenerator, "NodePathGenerator not set in GraphFilter");
        return this.nodePathGenerator.getPath(packageDataNode, null, DELIMITER);
    }
}

