/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import net.kemitix.node.Node;
import net.kemitix.pdg.maven.AbstractDotFileFormat;
import net.kemitix.pdg.maven.DotFileFormat;
import net.kemitix.pdg.maven.DotFileFormatFactory;
import net.kemitix.pdg.maven.DotFileFormatNested;
import net.kemitix.pdg.maven.DotFileFormatSimple;
import net.kemitix.pdg.maven.GraphFilter;
import net.kemitix.pdg.maven.NodePathGenerator;
import net.kemitix.pdg.maven.PackageData;
import net.kemitix.pdg.maven.TreeFilter;

@Immutable
class DefaultDotFileFormatFactory
implements DotFileFormatFactory {
    private final NodePathGenerator nodePathGenerator;
    private final GraphFilter graphFilter;
    private final TreeFilter treeFilter;

    @Inject
    DefaultDotFileFormatFactory(NodePathGenerator nodePathGenerator, GraphFilter graphFilter, TreeFilter treeFilter) {
        this.nodePathGenerator = nodePathGenerator;
        this.graphFilter = graphFilter;
        this.treeFilter = treeFilter;
    }

    @Override
    public DotFileFormat create(String format, Node<PackageData> base) {
        AbstractDotFileFormat reportFormat;
        Node<PackageData> tree = this.treeFilter.filterTree(base);
        switch (format) {
            case "simple": {
                reportFormat = new DotFileFormatSimple(tree, this.nodePathGenerator, this.graphFilter);
                break;
            }
            default: {
                reportFormat = new DotFileFormatNested(tree, this.nodePathGenerator, this.graphFilter);
            }
        }
        return reportFormat;
    }
}

