/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import net.kemitix.pdg.maven.DependencyData;
import net.kemitix.pdg.maven.DigraphFactory;
import net.kemitix.pdg.maven.DigraphMojo;
import net.kemitix.pdg.maven.DigraphService;
import net.kemitix.pdg.maven.DotFileFormatFactory;
import net.kemitix.pdg.maven.FileLoader;
import net.kemitix.pdg.maven.ReportGenerator;
import net.kemitix.pdg.maven.ReportWriter;
import net.kemitix.pdg.maven.SourceDirectoryProvider;
import net.kemitix.pdg.maven.SourceFileAnalyser;
import net.kemitix.pdg.maven.SourceFileProvider;

@Immutable
class DefaultDigraphService
implements DigraphService {
    private static final String REPORT_FILE = "digraph.dot";
    private final SourceDirectoryProvider directoryProvider;
    private final SourceFileProvider fileProvider;
    private final FileLoader fileLoader;
    private final SourceFileAnalyser fileAnalyser;
    private final ReportGenerator reportGenerator;
    private final ReportWriter reportWriter;
    private final DotFileFormatFactory dotFileFormatFactory;

    @Inject
    DefaultDigraphService(SourceDirectoryProvider directoryProvider, SourceFileProvider fileProvider, FileLoader fileLoader, SourceFileAnalyser fileAnalyser, ReportGenerator reportGenerator, ReportWriter reportWriter, DotFileFormatFactory dotFileFormatFactory) {
        this.directoryProvider = directoryProvider;
        this.fileProvider = fileProvider;
        this.fileLoader = fileLoader;
        this.fileAnalyser = fileAnalyser;
        this.reportGenerator = reportGenerator;
        this.reportWriter = reportWriter;
        this.dotFileFormatFactory = dotFileFormatFactory;
    }

    @Override
    public void execute(DigraphMojo mojo) {
        DependencyData dependencyData = DigraphFactory.newDependencyData(mojo.getBasePackage());
        this.fileProvider.process(this.directoryProvider.getDirectories(mojo.getProjects(), mojo.isIncludeTests())).stream().map(this.fileLoader::asInputStream).forEach(in -> this.fileAnalyser.analyse(dependencyData, (InputStream)in));
        dependencyData.updateNames();
        if (mojo.isDebug()) {
            dependencyData.debugLog(mojo.getLog());
        }
        try {
            File outputDirectory = new File(mojo.getProject().getBuild().getDirectory());
            outputDirectory.mkdirs();
            this.reportWriter.write(this.reportGenerator.generate(this.dotFileFormatFactory.create(mojo.getFormat(), dependencyData.getBaseNode())), new File(outputDirectory, REPORT_FILE).getAbsolutePath());
        }
        catch (IOException ex) {
            mojo.getLog().error((CharSequence)ex.getMessage());
        }
    }
}

