/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.pdg.maven;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import net.kemitix.node.Node;
import net.kemitix.pdg.maven.DotFileFormat;
import net.kemitix.pdg.maven.GraphFilter;
import net.kemitix.pdg.maven.NodePackageDataComparator;
import net.kemitix.pdg.maven.NodePathGenerator;
import net.kemitix.pdg.maven.PackageData;
import net.kemitix.pdg.maven.digraph.Digraph;
import net.kemitix.pdg.maven.digraph.EdgeElement;
import net.kemitix.pdg.maven.digraph.EdgeEndpoint;
import net.kemitix.pdg.maven.digraph.ElementContainer;
import net.kemitix.pdg.maven.digraph.GraphElement;
import net.kemitix.pdg.maven.digraph.NodeElement;
import net.kemitix.pdg.maven.digraph.NodeProperties;
import net.kemitix.pdg.maven.digraph.PropertyElement;
import net.kemitix.pdg.maven.digraph.Subgraph;

@Immutable
public abstract class AbstractDotFileFormat
implements DotFileFormat {
    protected static final String CLOSE_BRACE = "]";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String LINE = System.lineSeparator();
    private final Node<PackageData> base;
    private final NodePathGenerator nodePathGenerator;
    private final NodePackageDataComparator nodePackageDataComparator;
    private final Map<Node<PackageData>, GraphElement> graphElements = new HashMap<Node<PackageData>, GraphElement>();
    private final GraphFilter graphFilter;

    AbstractDotFileFormat(Node<PackageData> base, NodePathGenerator nodePathGenerator, GraphFilter graphFilter) {
        this.base = base;
        this.nodePathGenerator = nodePathGenerator;
        this.graphFilter = graphFilter;
        this.nodePackageDataComparator = new NodePackageDataComparator();
    }

    @Override
    public final String renderReport() {
        Digraph digraph = this.createDigraph();
        this.getNodeInjector().injectNodes(digraph, this.base);
        this.getUsageInjector().injectUsages(digraph, this.base);
        return this.render(digraph);
    }

    @Override
    public final String render(Digraph digraph) {
        return "digraph{" + LINE + this.renderElements(digraph.getElements()) + "}" + LINE;
    }

    @Override
    public final String render(NodeProperties nodeProperties) {
        return "node[" + this.renderProperties(nodeProperties.getProperties()) + CLOSE_BRACE;
    }

    @Override
    public final String render(PropertyElement propertyElement) {
        return propertyElement.getName() + "=" + this.quoted(propertyElement.getValue());
    }

    final String getClusterId(Node<PackageData> node) {
        return this.getPath(node, "_");
    }

    private String getPath(Node<PackageData> headNode, String delimiter) {
        return this.nodePathGenerator.getPath(headNode, this.getBase(), delimiter);
    }

    private Digraph createDigraph() {
        return new Digraph.Builder(this).build();
    }

    private GraphUsageInjector getUsageInjector() {
        return (container, node) -> node.getChildren().stream().sorted(this.nodePackageDataComparator).forEach(this.injectUsagesByChildren(container));
    }

    private Consumer<Node<PackageData>> injectUsagesByChildren(ElementContainer container) {
        return childNode -> {
            childNode.findData().ifPresent(data -> data.getUses().stream().filter(n -> n.isDescendantOf(this.getBase())).sorted(this.nodePackageDataComparator).map(usedNode -> this.createEdgeElement((Node<PackageData>)childNode, (Node<PackageData>)usedNode)).filter(Optional::isPresent).map(Optional::get).forEach(container::add));
            this.getUsageInjector().injectUsages(container, (Node<PackageData>)childNode);
        };
    }

    private EdgeEndpoint findEdgeEndpoint(Node<PackageData> node) {
        if (node.getChildren().isEmpty()) {
            return this.findNodeElement(node);
        }
        return this.findSubgraph(node);
    }

    private NodeElement createNodeElement(Node<PackageData> node) {
        return new NodeElement(node, this.getNodeId(node), ((PackageData)node.getData()).getName(), this);
    }

    private Optional<EdgeElement> createEdgeElement(Node<PackageData> tail, Node<PackageData> head) {
        if (this.graphFilter.filterNodes(tail) || this.graphFilter.filterNodes(head)) {
            return Optional.of(new EdgeElement(this.findEdgeEndpoint(tail), this.findEdgeEndpoint(head), this));
        }
        return Optional.empty();
    }

    private NodeElement findNodeElement(Node<PackageData> node) {
        if (!this.graphElements.containsKey(node)) {
            this.graphElements.put(node, this.createNodeElement(node));
        }
        return (NodeElement)this.graphElements.get(node);
    }

    private Subgraph findSubgraph(Node<PackageData> node) {
        if (!this.graphElements.containsKey(node)) {
            this.graphElements.put(node, this.createSubgraph(node));
        }
        return (Subgraph)this.graphElements.get(node);
    }

    private Subgraph createSubgraph(Node<PackageData> node) {
        return new Subgraph(node, this.getClusterId(node), ((PackageData)node.getData()).getName(), this);
    }

    private GraphNodeInjector getNodeInjector() {
        return new GraphNodeInjector(){

            @Override
            public void injectNodes(ElementContainer container, Node<PackageData> node) {
                Set children = node.getChildren();
                if (children.isEmpty()) {
                    container.add(AbstractDotFileFormat.this.findNodeElement((Node<PackageData>)node));
                } else {
                    Subgraph subgraph = AbstractDotFileFormat.this.findSubgraph((Node<PackageData>)node);
                    children.stream().sorted(AbstractDotFileFormat.this.nodePackageDataComparator).forEach(c -> this.injectNodes(subgraph, (Node<PackageData>)c));
                    container.add(subgraph);
                }
            }
        };
    }

    final String getNodeId(Node<PackageData> node) {
        return this.getPath(node, ".");
    }

    final String renderElements(Collection<GraphElement> elements) {
        return elements.stream().map(GraphElement::render).collect(Collectors.joining(LINE));
    }

    private String renderProperties(Set<PropertyElement> properties) {
        return properties.stream().map(GraphElement::render).collect(Collectors.joining(";" + LINE));
    }

    final String quoted(String text) {
        return DOUBLE_QUOTE + text + DOUBLE_QUOTE;
    }

    protected Node<PackageData> getBase() {
        return this.base;
    }

    @FunctionalInterface
    static interface GraphUsageInjector {
        public void injectUsages(ElementContainer var1, Node<PackageData> var2);
    }

    @FunctionalInterface
    static interface GraphNodeInjector {
        public void injectNodes(ElementContainer var1, Node<PackageData> var2);
    }
}

