/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.quality.api;

import java.util.HashMap;
import lombok.NonNull;
import net.kemitix.quality.api.PluginGoal;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractPluginGoal
implements PluginGoal {
    private static final String CONFIGURATION = "Configuration";
    private final Plugin plugin = new Plugin();
    private final Xpp3Dom configuration = new Xpp3Dom("Configuration");

    protected AbstractPluginGoal() {
        this.plugin.setConfiguration((Object)this.configuration);
    }

    @Override
    public void groupArtifactVersion(@NonNull String groupId, @NonNull String artifactId, @NonNull String version) {
        if (groupId == null) {
            throw new NullPointerException("groupId");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.plugin.setGroupId(groupId);
        this.plugin.setArtifactId(artifactId);
        this.plugin.setVersion(version);
    }

    protected final void addRootElement(String name, boolean value) {
        this.addRootElement(name, AbstractPluginGoal.booleanToString(value));
    }

    protected final void addRootElement(String name, String value) {
        this.addChildElement(this.getConfiguration(), name, value);
    }

    protected final void addChildElement(Xpp3Dom parent, String name, String value) {
        Xpp3Dom basePackageElement = new Xpp3Dom(name);
        basePackageElement.setValue(value);
        parent.addChild(basePackageElement);
    }

    private static String booleanToString(boolean value) {
        HashMap<Boolean, String> booleanStringMap = new HashMap<Boolean, String>(2);
        booleanStringMap.put(false, "false");
        booleanStringMap.put(true, "true");
        return (String)booleanStringMap.get(value);
    }

    protected final void addDependency(String groupId, String artifactId, String version) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        this.getPlugin().addDependency(dependency);
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Xpp3Dom getConfiguration() {
        return this.configuration;
    }
}

