/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.fontface;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import net.kemitix.fontface.FatalFontFaceError;
import net.kemitix.fontface.FontFace;

public class FontLoader {
    private static final Logger LOGGER = Logger.getLogger(FontLoader.class.getName());

    public Font loadFont(FontFace fontFace) {
        URI fontUri = fontFace.getFontLocation();
        LOGGER.info(String.format("Loading %s", fontUri));
        HashMap<TextAttribute, Integer> map = new HashMap<TextAttribute, Integer>();
        map.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        try {
            return Font.createFont(0, new File(fontUri)).deriveFont(map);
        }
        catch (FontFormatException | IOException e) {
            throw new FatalFontFaceError("Font load error", e);
        }
    }
}

