/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.fontface;

import java.net.URI;

public class FontFace {
    private URI fontLocation;
    private int size;
    private String colour;
    private String shadowColour;
    private int shadowOffsetX;
    private int shadowOffsetY;

    public static FontFace of(URI fontUri, int size, String colour, int shadowOffsetX, int shadowOffsetY) {
        String shadowColour = FontFace.shadowColour(colour);
        return new FontFace(fontUri, size, colour, shadowColour, shadowOffsetX, shadowOffsetY);
    }

    public static FontFace of(URI fontUri, int size, String colour) {
        return FontFace.of(fontUri, size, colour, 0, 0);
    }

    static String shadowColour(String colour) {
        switch (colour) {
            case "white": 
            case "yellow": {
                return "black";
            }
        }
        return "white";
    }

    public URI getFontLocation() {
        return this.fontLocation;
    }

    public int getSize() {
        return this.size;
    }

    public String getColour() {
        return this.colour;
    }

    public String getShadowColour() {
        return this.shadowColour;
    }

    public int getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public int getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public FontFace withFontLocation(URI fontLocation) {
        return this.fontLocation == fontLocation ? this : new FontFace(fontLocation, this.size, this.colour, this.shadowColour, this.shadowOffsetX, this.shadowOffsetY);
    }

    public FontFace withSize(int size) {
        return this.size == size ? this : new FontFace(this.fontLocation, size, this.colour, this.shadowColour, this.shadowOffsetX, this.shadowOffsetY);
    }

    public FontFace withColour(String colour) {
        return this.colour == colour ? this : new FontFace(this.fontLocation, this.size, colour, this.shadowColour, this.shadowOffsetX, this.shadowOffsetY);
    }

    public FontFace withShadowColour(String shadowColour) {
        return this.shadowColour == shadowColour ? this : new FontFace(this.fontLocation, this.size, this.colour, shadowColour, this.shadowOffsetX, this.shadowOffsetY);
    }

    public FontFace withShadowOffsetX(int shadowOffsetX) {
        return this.shadowOffsetX == shadowOffsetX ? this : new FontFace(this.fontLocation, this.size, this.colour, this.shadowColour, shadowOffsetX, this.shadowOffsetY);
    }

    public FontFace withShadowOffsetY(int shadowOffsetY) {
        return this.shadowOffsetY == shadowOffsetY ? this : new FontFace(this.fontLocation, this.size, this.colour, this.shadowColour, this.shadowOffsetX, shadowOffsetY);
    }

    private FontFace() {
    }

    FontFace(URI fontLocation, int size, String colour, String shadowColour, int shadowOffsetX, int shadowOffsetY) {
        this.fontLocation = fontLocation;
        this.size = size;
        this.colour = colour;
        this.shadowColour = shadowColour;
        this.shadowOffsetX = shadowOffsetX;
        this.shadowOffsetY = shadowOffsetY;
    }
}

