/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.fontface;

import java.awt.Font;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import net.kemitix.fontface.FontFace;
import net.kemitix.fontface.FontLoader;

public class FontCache {
    private static final Logger LOGGER = Logger.getLogger(FontCache.class.getName());
    private final Map<URI, Font> fileCache = new HashMap<URI, Font>();
    private final Map<FontAndSize, Font> fontCache = new HashMap<FontAndSize, Font>();
    private final FontLoader fontLoader;

    public Font loadFont(FontFace fontFace) {
        LOGGER.finest(String.format("Requesting %s %d", fontFace.getFontLocation(), fontFace.getSize()));
        Font baseFont = this.fileCache.computeIfAbsent(fontFace.getFontLocation(), this.loadNewFontFile(fontFace));
        return this.fontCache.computeIfAbsent(FontAndSize.of(baseFont, fontFace.getSize()), this.resizeFont());
    }

    private Function<URI, Font> loadNewFontFile(FontFace fontFace) {
        return uri -> {
            LOGGER.fine(String.format("Loading %s", uri));
            return this.fontLoader.loadFont(fontFace);
        };
    }

    private Function<FontAndSize, Font> resizeFont() {
        return fontAndSize -> {
            LOGGER.finer(String.format("Resizing %s to %d", fontAndSize.getFont().getName(), fontAndSize.getSize()));
            return fontAndSize.font.deriveFont(0, fontAndSize.getSize());
        };
    }

    public FontCache(FontLoader fontLoader) {
        this.fontLoader = fontLoader;
    }

    private static class FontAndSize {
        private final Font font;
        private final int size;

        private FontAndSize(Font font, int size) {
            this.font = font;
            this.size = size;
        }

        static FontAndSize of(Font font, int size) {
            return new FontAndSize(font, size);
        }

        public Font getFont() {
            return this.font;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FontAndSize)) {
                return false;
            }
            FontAndSize other = (FontAndSize)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Font this$font = this.getFont();
            Font other$font = other.getFont();
            if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
                return false;
            }
            return this.getSize() == other.getSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FontAndSize;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Font $font = this.getFont();
            result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
            result = result * 59 + this.getSize();
            return result;
        }
    }
}

